
#ifndef SGPIO_VGA_H
#define SGPIO_VGA_H

////////////////////////////////////////////////////////////////////////////////
//
//	800x600
//		SVGA data stored in SDRAM   6 bits of data, 2 bits for HSYNC and VSYNC
//
//                                                       40      128       88
//		0     ------------ video data ---------- 799   blank   hor-sync b-porch
//		1056  |                                   |
//      2112  |                                   |
//            /                                   /
//            \                                   \
//      63360 |-----------------------------------|
//
//      1 blank line
//      4 sync lines
//      23 back porch
//
//

// these values from the excel spreadsheet

#if 1		// EINK

#define PIXELrate		16000000

#define BYTEperHLINE	200
#define HFPORCH			17
#define HSYNC			200
#define HBPORCH			85

#define NUMhorizLINES	600
#define VFPORCH			18
#define VSYNC			4
#define VBPORCH			4

  #if 0		// VGA

#define PIXELrate		25175000
#define PLL0ctrl		0x6014
//#define PLL0mdiv 		0xba22a6
//#define PLL0npdiv		0x20200a

// the current C code deals in multiples of 32 pixels, so some of these are not really to VGA spec, and will be larger

#define BYTEperHLINE	640	
#define HFPORCH			16
#define HSYNC			96
#define HBPORCH			48

#define NUMhorizLINES	480
#define VFPORCH			10	
#define VSYNC			2
#define VBPORCH			33

   #endif

#else 		// SVGA		-- just for reference, the CPU can't keep up with a 50 MHz rate

#define PIXELrate		40000000
#define PLL0ctrl		0x6014
//#define PLL0mdiv 		0xba22a6
//#define PLL0npdiv		0x20200a

#define BYTEperHLINE	800
#define HFPORCH			40
#define HSYNC			128
#define HBPORCH			88

#define NUMhorizLINES	600
#define VFPORCH			1
#define VSYNC			4
#define VBPORCH			23

#endif

//  the output uses a CPU to poll SGPIO ready and write 8x32bits or 32 pixels+control
//
void dumpVGA(void) ;		// this routine never exits, it just dumps SDRAM -> VGA 

////////////////////////// setup sGPIO ///////////////////////
//
//
void setupVGA(void) ;

//
//  bte hacks
//
//////////////////////////////////////////////////////////////////////////////////////////

#endif
