////////////////////////////////////////////////////////////////////////
//   read an 800 x 600 .bmp 256 color file and spit out .hex for eink
//

#define MAX_BMPFILE	800*600

#include <windows.h>
#include <io.h>
#include <conio.h>

#include <stdio.h>      // stdout
#include <stdarg.h>

#include <fcntl.h>


#ifndef O_BINARY
#define O_BINARY 0
#endif // O_BINARY

char bmpfile[MAX_BMPFILE];
char pixelfile[120000];

#define GRAY2
	
int twobits(int x) {	// return 2 bit value of pixel
	int val;
	
	// convert 8 bit color to 2 bits of gray -- mostly looking at reg right now
		
	val  = x & 0x80 ? 2 : 0;
	val += x & 0x40 ? 1 : 0;
	
	
#ifdef BLACKWHITE	// major shade
	switch (val) {		// odd mapping of 2 bits for eink display
		case 0:	val = 1; break;
		case 1:	val = 1; break;
		case 2:	val = 2; break;
		case 3: val = 2; break;
	}
#endif
#ifdef GRAY1		// alternate for bright gray
	switch (val) {		// odd mapping of 2 bits for eink display
		case 0:	val = 1; break;
		case 1:	val = 0; break;
		case 2:	val = 1; break;
		case 3: val = 2; break;
	}
#endif
#ifdef GRAY2		// neutral grays
	switch (val) {		// odd mapping of 2 bits for eink display
		case 0:	val = 1; break;
		case 1:	val = 0; break;
		case 2:	val = 0; break;
		case 3: val = 2; break;
	}
#endif
	return val;
}

int chksum,cnt_ihex;

void init_ihex(int val) {
	chksum = val;
	cnt_ihex = 0;
}

void put_ihex(int c) {
	c = c & 0xff;
	printf("%02X",c);
	chksum += c;
}

void put_ihex_chksum() {
	printf("%02X\n",(-chksum) & 0xFF);
}



int main(int argc, char *argv[]){
    char *input_file;                   /**< Name of the file to get input from. */
    FILE *fd;
    int line,col,pixel,start,addr;
    unsigned long  Pos;
    unsigned long  FileLength;
    char        *FileContent;              /**< Used to store the content of a hex */

	FileContent = bmpfile;
    input_file = argv[1];

   	fd = fopen(input_file, "rb");

    FileLength = fread(FileContent, 1, MAX_BMPFILE, fd);
	    
    if (FileLength < MAX_BMPFILE) {
		printf( "\nFileLength %d is too small\n",FileLength);
        exit(1);
   	}	    
    fclose(fd);
    
	start = (bmpfile[0xb]<<8)+bmpfile[0xa];		// get start of pixel area
    
	
#ifdef C_FORMAT
	   
    printf("// file length is %d\n",FileLength);
    		
	printf("\n\nchar Pixels[]= {");
	
	for(line=0; line<600; line++){
		for(col=0; col<800; ) {
			pixel  = twobits(bmpfile[start + (line+1)*800 -1 - col++])<<6;
			pixel += twobits(bmpfile[start + (line+1)*800 -1 - col++])<<4;
			pixel += twobits(bmpfile[start + (line+1)*800 -1 - col++])<<2;
			pixel += twobits(bmpfile[start + (line+1)*800 -1 - col++])<<0;
			
			if ((line == 599) && (col >=800)) {
				printf("0x%02x\n};\n\n",pixel);
			} else {
			  if ((line < 10) && (col <80)) {
			  	if ((col & 0x1f) == 0) printf("\n    ");
			  	printf("0x%02x, ",pixel);
			  }
			}
		}
	}
#elif defined INTEL_HEX

	addr = 0;
	
	for(line=0; line<600; line++){
		for(col=0; col<800; ) {

			pixel  = twobits(bmpfile[start + (line+1)*800 -1 - col++])<<6;
			pixel += twobits(bmpfile[start + (line+1)*800 -1 - col++])<<4;
			pixel += twobits(bmpfile[start + (line+1)*800 -1 - col++])<<2;
			pixel += twobits(bmpfile[start + (line+1)*800 -1 - col++])<<0;
			
			if ((addr & 0x1f) == 0) {
				if ((addr >= 0x10000) && ((addr & 0xffff) == 0)) {
					printf(":00%04X02%02X\n",addr >> 4,0xee - (addr>>16));		// may not be the right checksum
				}
				printf(":20%04X00",addr & 0xFFFF);
				
				init_ihex (0x20 + addr + (addr >> 8));
			}
			put_ihex(pixel);	
			addr++;
				
			if ((addr & 0x1f) == 0) {
				put_ihex_chksum();
			}
		}
	}

	printf(":00000001FF\n");
					
#else
#error	pick a format  -DINTEL_HEX or -DC_FORMAT
#endif
			
}

