/* header file that defines symbols and init functions 
   for serial flash manufacturers
   Copyright (C) NXP Semiconductors 2010 */
 
/* to avoid having a separate .h file for each manufacturer.
   symbols in flash registers are defined here */

#ifndef __MFGER_H__
#define __MFGER_H__
 
/* Winbond status */
#define stat_SRP0 0x80
#define stat_WBOND_SEC 0x40
#define stat_TB 0x20
#define stat_BP_MASK 0x1C
#define stat_BP_SHIFT 2
/* WEL in same place for Winbond and SST! */
#define stat_WEL 2
#define stat_WBOND_BUSY 1
#define stat_SUS 0x80
#define stat_CMP 0x40
#define stat_LB_MASK 0x3C
#define stat_LB_SHIFT 2
#define stat_QE2 2
#define stat_SRP1 1
/* SST status */
#define stat_SST_BUSY 0x80
#define stat_SST_SEC 0x20
#define stat_WPLD 0x10
#define stat_WSP 8
#define stat_WSE 4
/* Numonyx (was ST now Micron) status */
#define stat_DIS_QUAD 0x80
#define stat_DIS_DUAL 0x40
#define stat_DUMMIES_SHIFT 4
#define stat_NO_XIP 8
/* Atmel */
#define stat_QE80 0x80
/* Chingis */
#define stat_QE_chi 0x40

/* command codes */
#define CMD_4BYTE_ADDR ((unsigned)0xB7)
#define CMD_CLEAR_ERR_SPAN 0x30
#define CMD_CLR_STUFF ((unsigned)0xFF)
#define CMD_CLR_QIO   ((unsigned)0xF5)
#define CMD_EN_QUADIO 0x38
#define CMD_ERASE_128K ((unsigned)0xD2)
#define CMD_ERASE_32K 0x52
#define CMD_ERASE_4K 0x20
#define CMD_ERASE_64K ((unsigned)0xD8)
#define CMD_ERASE_CHIP ((unsigned)0xC7)
#define CMD_ERASE_CHIP2 0x60
#define CMD_ERASE_PAGE ((unsigned)0xDB)
#define CMD_PROG 2
#define CMD_PROG_DUAL_I  ((unsigned)0xA2)
#define CMD_PROG_DUAL_IO ((unsigned)0xD2)
#define CMD_PROG_QUAD 0x32
#define CMD_PROG_QUAD_MXIC 0x38
#define CMD_PROG_QUAD_NUMO 0x12
#define CMD_PROT_SECT 0x36
#define CMD_RDCONF 0x3F
#define CMD_RDSTAT 5
#define CMD_RDSTAT2 0x35
#define CMD_RD 0x03
#define CMD_RD_JEDEC_ID ((unsigned)0x9F)
#define CMD_RD_LOCK_REG ((unsigned)0xE8)
#define CMD_RD_NV_CONF ((unsigned)0xB5)
#define CMD_RD_PROTREG 0x72
#define CMD_RD_PROT_SECT 0x3C
#define CMD_RD_SECURITY 0x2B
#define CMD_RD_VOL_CONF ((unsigned)0x85)
#define CMD_RD_VOL_ENH_CONF 0x65
#define CMD_READ_FAST 0x0B
#define CMD_READ_DUAL_O 0x3B
#define CMD_READ_DUAL_IO ((unsigned)0xBB)
#define CMD_READ_QUAD_IO ((unsigned)0xEB)
#define CMD_READ_QUAD_OUT 0x6B
#define CMD_RESET_ENABLE 0x66
#define CMD_RESET_MEMORY ((unsigned)0x99)
#define CMD_SET_HIPERF ((unsigned)0xA3)
#define CMD_SET_READ_PARAMS ((unsigned)0xC0)
#define CMD_UNPROT_SECT 0x39
#define CMD_WRCONF 0x3E
#define CMD_WREN 6
#define CMD_WRSTAT 1
#define CMD_WR_LOCK_REG ((unsigned)0xE5)
#define CMD_WR_NV_CONF ((unsigned)0xB1)
#define CMD_WR_PROTREG 0x42
#define CMD_WR_VOL_CONF ((unsigned)0x81)
#define CMD_WR_VOL_ENH_CONF 0x61
 
/* manufacturer-specific initialization routines, called by spifi_init() */
int span (SPIFIobj*, unsigned, unsigned); // MCB4300 EVB
int eon  (SPIFIobj*, unsigned, unsigned); // Pixart LPC4320 DVB
// int amic (SPIFIobj*, unsigned, unsigned);
// int atm  (SPIFIobj*, unsigned, unsigned);
int chi  (SPIFIobj*, unsigned, unsigned);
// int esmt (SPIFIobj*, unsigned, unsigned);
// int giga (SPIFIobj*, unsigned, unsigned);
// int mxic (SPIFIobj*, unsigned, unsigned);
// int numo (SPIFIobj*, unsigned, unsigned);

// int sst  (SPIFIobj*, unsigned, unsigned);
// int wbd  (SPIFIobj*, unsigned, unsigned);

#endif
