#include <stdint.h>
#include <lpc43xx_rit.h>

static volatile uint32_t _rit_count;

void RIT_IRQHandler(void)
{
	RITIMER_CLR_INT;
	_rit_count ++;
}

void rit_init(uint32_t intv_ms)
{
	RITIMER_DISABLE;
	RITIMER_CLR_INT;
	RITIMER_AUTO_RESET_EN;
	RITIMER_SET_COMPVAL(214458 * intv_ms);
	RITIMER_SET_RI_COUNTER(0);
	RITIMER_ENABLE;
	_rit_count = 0;
	NVIC_EnableIRQ(RITIMER_IRQn); //  enable RI timer interrrupts
}

uint32_t rit_get_counter(void)
{
	return _rit_count;
}

void rit_delay_ms(uint32_t delay_ms)
{
	uint32_t delay_b;

	delay_b = _rit_count;

	while (1) {
		if (delay_b + delay_ms == _rit_count) {
			break;
		}
	}
}
