#ifndef	__BRUCE_I2C
#define	__BRUCE_I2C
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//
//		simple version or i2c for devices with a register address followed by 1 byte to read or write


#define SFSP2_3_CONFIGURE_I2C1_SDA					(0x00000001 | MD_ZI | MD_EZI)
#define SFSP2_4_CONFIGURE_I2C1_SCL					(0x00000001 | MD_ZI | MD_EZI)
#define SFSI2C0_CONFIGURE_STANDARD_FAST_MODE		(1<<3 | 1<<11)


/** SLA+R has been transmitted, NACK has been received */
#define I2C_I2STAT_M_RX_SLAR_NACK				((0x48))
/** Data has been received, ACK has been returned */
#define I2C_I2STAT_M_RX_DAT_ACK					((0x50))
/** Data has been received, NACK has been return */
#define I2C_I2STAT_M_RX_DAT_NACK				((0x58))

/** SLA+W has been transmitted, NACK has been received */
#define I2C_I2STAT_M_TX_SLAW_NACK				((0x20))
/** Data has been transmitted, ACK has been received */
#define I2C_I2STAT_M_TX_DAT_ACK					((0x28))
/** Data has been transmitted, NACK has been received */
#define I2C_I2STAT_M_TX_DAT_NACK				((0x30))

#define I2C_I2CON_AA			((0x04)) /*!< Assert acknowledge flag */
#define I2C_I2CON_SI			((0x08)) /*!< I2C interrupt flag */
#define I2C_I2CON_STO			((0x10)) /*!< STOP flag */
#define I2C_I2CON_STA			((0x20)) /*!< START flag */
#define I2C_I2CON_I2EN			((0x40)) /*!< I2C interface enable */


/********************************************************************//**
 * I2C Status Code definition (I2C Status register)
 *********************************************************************/
/* Return Code in I2C status register */
#define I2C_STAT_CODE_BITMASK		((0xF8))

void I2C_Init(LPC_I2Cn_Type *I2Cx, uint32_t clockrate);
int I2C_Write(LPC_I2Cn_Type *I2Cx, int slaveADDR, int regADDR, int regDATA);
int I2C_Read(LPC_I2Cn_Type *I2Cx, int slaveADDR, int regADDR);

#endif	//__BRUCE_I2C
