//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//
//		capture an image

void setup_SGPIO_image_capture(void) {
	
	LPC_CGU->BASE_PERIPH_CLK = 0x09000000;	
	
    LPC_SGPIO->CLR_EN_0	= 0xffff;		// disable interrupting on clock
    LPC_SGPIO->CLR_EN_1	= 0xffff;		// disable interrupting on clock

	/* Disable all counters (should be in this state after reset but just make sure) */
	LPC_SGPIO->CTRL_ENABLED = 0;	

	/* Set all pins as input */
	LPC_SGPIO->GPIO_OENREG = 0;
	
#define INV_OUT_CLK   (1<<3)

#define CONCAT_ENABLE (1<<11)
#define SLICE_2		  (1<<12)
#define SLICE_4		  (2<<12)
#define SLICE_8		  (3<<12)	

#define BIT_MODE	  (0<<6)
#define BIT2_MODE	  (1<<6)
#define NIBBLE_MODE	  (2<<6)
#define BYTE_MODE	  (3<<6)

#define CLKGEN_EXT		(1<<2)

#define EXT_CLK_SGPIO8	0x01
#define EXT_CLK_SGPIO9	0x03
#define EXT_CLK_SGPIO10	0x05
#define EXT_CLK_SGPIO11	0x07

#define EXT_QUAL_SGPIO8		((3<<5) | (0<<7))
#define EXT_QUAL_SGPIO9		((3<<5) | (1<<7))
#define EXT_QUAL_SGPIO10	((3<<5) | (2<<7))
#define EXT_QUAL_SGPIO11	((3<<5) | (3<<7))

////////////////////////////////////////////////////////////////////////////////
//
//	set all the clocks to the same frequency
//


	
	LPC_SGPIO->PRESET[0]  = 				
	LPC_SGPIO->PRESET[8]  = 				
	LPC_SGPIO->PRESET[4]  = 				
	LPC_SGPIO->PRESET[9]  = 				
	LPC_SGPIO->PRESET[2]  = 
	LPC_SGPIO->PRESET[10] = 			
	LPC_SGPIO->PRESET[5]  = 
	LPC_SGPIO->PRESET[11] = 0;		// 8 slice buffer
		
	/* Load counter with initial value */

	LPC_SGPIO->COUNT[0]  =				// clock
	LPC_SGPIO->COUNT[8]  =				
	LPC_SGPIO->COUNT[4]  =	
	LPC_SGPIO->COUNT[9]  =			
	LPC_SGPIO->COUNT[2]  =
	LPC_SGPIO->COUNT[10] = 			
	LPC_SGPIO->COUNT[5]  =
	LPC_SGPIO->COUNT[11] = 0;		// 8 slice buffer 
	
	
	
	/*************************************/
	/* Program slice A(0) as pixel buffer */
	/*************************************/

	LPC_SGPIO->SLICE_MUX_CFG[0]  = 	
	LPC_SGPIO->SLICE_MUX_CFG[8]  = 	
	LPC_SGPIO->SLICE_MUX_CFG[4]  = 	
	LPC_SGPIO->SLICE_MUX_CFG[9]  = 	
	LPC_SGPIO->SLICE_MUX_CFG[2]  = 	
	LPC_SGPIO->SLICE_MUX_CFG[10] = 	
	LPC_SGPIO->SLICE_MUX_CFG[5]  = 	
	LPC_SGPIO->SLICE_MUX_CFG[11] =  CLKGEN_EXT  |  BYTE_MODE;	
	
	LPC_SGPIO->SGPIO_MUX_CFG[0]  =                 SLICE_8   | EXT_CLK_SGPIO8 | EXT_QUAL_SGPIO9   ;	 // inputs from data pin
	LPC_SGPIO->SGPIO_MUX_CFG[8]  = 	
	LPC_SGPIO->SGPIO_MUX_CFG[4]  = 	
	LPC_SGPIO->SGPIO_MUX_CFG[9]  = 	
	LPC_SGPIO->SGPIO_MUX_CFG[2]  = 	
	LPC_SGPIO->SGPIO_MUX_CFG[10] = 	
	LPC_SGPIO->SGPIO_MUX_CFG[5]  = 	
	LPC_SGPIO->SGPIO_MUX_CFG[11] = CONCAT_ENABLE | SLICE_8   | EXT_CLK_SGPIO8 | EXT_QUAL_SGPIO9   ;	
	
	LPC_SGPIO->POS[0]  = 	
	LPC_SGPIO->POS[8]  = 	
	LPC_SGPIO->POS[4]  = 	
	LPC_SGPIO->POS[9]  = 	
	LPC_SGPIO->POS[2]  = 	
	LPC_SGPIO->POS[10] = 	
	LPC_SGPIO->POS[5]  = 	
	LPC_SGPIO->POS[11] = ((0x020-1)<<8) | (0x020-1);
	
	
/////////////////////////////////////////////////////////	

	// watch the slice clock --
			
	LPC_SGPIO->OUT_MUX_CFG[13]  = 8;	// clockout from slice J
	scu_pinmux(0x1 ,20, MD_PUP, FUNC6);	//  SGPIO13: -- SV3.9	
	LPC_SGPIO->GPIO_OENREG |= (1<<13);
	
	
/////////////////////////////////////////////////////////////////////////////////
	/* Enable counter under test to start pixel stream generation */
	LPC_SGPIO->CTRL_ENABLED = (1<<0) | (1<<8) | (1<<4) | (1<<9)
							| (1<<2) | (1<<10) | (1<<5) | (1<<11) ;
							
	

// and SGPIO pins
///////////////////////////// setup SGPIO ///////////////////
//
//	handle the pin mux setup for SGPIO
//
	/* validation board with 256BGA */
	
// pixel inputs bit 7 is MSB	

	scu_pinmux(0x9 ,0 , MD_EZI | MD_PUP, FUNC6);	//  SGPIO0: -- SV11.4	
	scu_pinmux(0x9 ,1 , MD_EZI | MD_PDN, FUNC6);	//  SGPIO1: -- SV13.4	
	scu_pinmux(0x9 ,2 , MD_EZI | MD_PUP, FUNC6);	//  SGPIO2: -- SV15.4
	scu_pinmux(0x9 ,5 , MD_EZI | MD_PDN, FUNC6);	//  SGPIO3: -- SV5.4	
	scu_pinmux(0x6 ,3 , MD_EZI | MD_PUP, FUNC2);	//  SGPIO4: -- SV5.2
	scu_pinmux(0x7 ,1 , MD_EZI | MD_PDN, FUNC7);	//  SGPIO5: -- X11.22	
	scu_pinmux(0xf ,7 , MD_EZI | MD_PUP, FUNC6);	//  SGPIO6: -- X5.18
	scu_pinmux(0xf ,8 , MD_EZI | MD_PDN, FUNC6);	//  SGPIO7: -- X5.20	

//  clkin pin
	scu_pinmux(0x8, 0, MD_EZI | MD_PDN, FUNC4); 	//  SGPIO8: pixel clock  SV5.8

//  clk qualifier pin -- HREF
	scu_pinmux(0x8, 1, MD_EZI | MD_PUP, FUNC4); 	//  SGPIO9: pixel qualifier  JP3.1
	
//  VREF sync up on a frame here	
	scu_pinmux(0xe,11, MD_EZI | MD_PUP, FUNC4); 	//  GPIO7[11]: VREF  SV11.2
	

	//\\\\\\\\\\////////////// DEBUG \\\\\\\\\\\\\\\\\\\\\\//////////////////
//  wiggle this pin for debug
	scu_pinmux(0xF, 3, MD_PDN, FUNC4); 			// GPIO7[18]  -- a line to wiggle for debug

}



/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////

// By assigning some local pointers to the following macros and the writes to the shadow register
// and looking at the resultant assembly code what was originally marginal at 25 MHz now runs up past 30 MHz (marginal at 35)

#define	sgpio_wait4reload 				while ((sgpio_status1[0] & 1) == 0);
#define sgpio_clear_status				sgpio_status1[1] = 0x0001			 // clear A slice -- capture clock status


#define CAM_WIDTH	320
#define CAM_HEIGHT	240

#ifdef CAM130
  #define I2C_SLAVE_ADDR	0x60
#else
  #define I2C_SLAVE_ADDR	0x78		// Toshiba camera
#endif


#define CAM_BUF_START	0x28008300

#define TIMEOUT 100000

void capture_image(void) {
	int row,col;
	int timeout,x;

	int *pixelPTR = (int *) CAM_BUF_START;  	
	
	volatile unsigned int *sgpio_shadow = &LPC_SGPIO->REG_SS[0];
	volatile unsigned int *sgpio_status1 = (volatile unsigned int *)&LPC_SGPIO->STATUS_1;

	I2C_Write(LPC_I2C0, I2C_SLAVE_ADDR, 0x3, 0x6);
	
	timeout = TIMEOUT;
	while ((LPC_GPIO_PORT->PIN[7] & (1 << 11)) == 0) {if (--timeout == 0) return;};
	timeout = TIMEOUT;
	while (LPC_GPIO_PORT->PIN[7] & (1 << 11))        {if (--timeout == 0) return;};

	LPC_GPIO_PORT->DIR[7] = 1<<18;

	LPC_SGPIO->POS[0]  = 	
	LPC_SGPIO->POS[8]  = 	
	LPC_SGPIO->POS[4]  = 	
	LPC_SGPIO->POS[9]  = 	
	LPC_SGPIO->POS[2]  = 	
	LPC_SGPIO->POS[10] = 	
	LPC_SGPIO->POS[5]  = 	
	LPC_SGPIO->POS[11] = ((0x020-1)<<8) | (0x020-1);	// make sure the POS pointers start at "0"

	sgpio_clear_status;		// empty buffers at the beginning of a frame

	for (row=0; row<CAM_HEIGHT; row++) {				

		for (col=0; col<CAM_WIDTH; col += 16) {
			
//			sgpio_wait4reload;
			timeout = TIMEOUT;
			while ((sgpio_status1[0] & 1) == 0) {if (--timeout == 0) return;};

			sgpio_clear_status;
				
	LPC_GPIO_PORT->SET[7] = 1<<18;	  			// wiggling for debug
			
			*pixelPTR++ = sgpio_shadow[11] ;
			*pixelPTR++ = sgpio_shadow[5]  ;
			*pixelPTR++ = sgpio_shadow[10] ;
			*pixelPTR++ = sgpio_shadow[2]  ;
			*pixelPTR++ = sgpio_shadow[9]  ;
			*pixelPTR++ = sgpio_shadow[4]  ;
			*pixelPTR++ = sgpio_shadow[8]  ;
			*pixelPTR++ = sgpio_shadow[0]  ;
			
	LPC_GPIO_PORT->CLR[7] = 1<<18;			   // debug wiggle
		}
		pixelPTR = (int *) CAM_BUF_START + row *(LCD_WIDTH>>1);
	}

	// try to color correct the image
#if 0	
	pixelPTR = (int *) CAM_BUF_START;  //&cambuf;	
	for (row=0; row<CAM_HEIGHT; row++) {				

		for (col=0; col<CAM_WIDTH; col += 2) {		  // should be += 2
			x = *pixelPTR ;
			*pixelPTR++ = (x & 0x07e007e0) + ((x & 0xF800F800)>>11) + ((x & 0x001f001f)<<11);
		}

		pixelPTR = (int *) CAM_BUF_START + row *(LCD_WIDTH>>1);
	}
#endif
}




//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//
//		Camera setup, including i2c register programming


#define I2CDEV_M LPC_I2C0


//	pairs of register addresses and values to be written via i2c to camera chip for initialization, terminated by -1
int  camREGs[] = {

 #ifdef CAM130
  
  #define OV9650_I2C_ADDR 0x60


#define OV9650_MANUFACT_ID	0x7FA2
#define OV9650_PRODUCT_ID	  0x9650

/* Registers */
#define REG_GAIN	0x00	/* Gain lower 8 bits (rest in vref) */
#define REG_BLUE	0x01	/* blue gain */
#define REG_RED		0x02	/* red gain */
#define REG_VREF	0x03	/* Pieces of GAIN, VSTART, VSTOP */
#define REG_COM1	0x04	/* Control 1 */
#define  COM1_CCIR656	  0x40  /* CCIR656 enable */
#define REG_BAVE	0x05	/* U/B Average level */
#define REG_GbAVE	0x06	/* Y/Gb Average level */
#define REG_GrAVE	0x07	/* Cr Average Level */
#define REG_RAVE	0x08	/* V/R Average level */
#define REG_COM2	0x09	/* Control 2 */
#define  COM2_SSLEEP	  0x10	/* Soft sleep mode */
#define REG_PID		0x0a	/* Product ID MSB */
#define REG_VER		0x0b	/* Product ID LSB */
#define REG_COM3	0x0c	/* Output byte swap, signals reassign */
#define  COM3_SWAP	  0x40	  /* Byte swap */
#define  COM3_VARIOPIXEL1 0x04
#define REG_COM4	0x0d	/* Vario Pixels  */
#define  COM4_VARIOPIXEL2 0x80

#define REG_COM5	0x0e	/* System clock options */
#define   COM5_SLAVE_MODE 0x10
#define   COM5_SYSTEMCLOCK48MHZ 0x80

#define REG_COM6	0x0f	/* HREF & ADBLC options */
#define REG_AEC 	0x10	/* More bits of AEC value */
#define REG_CLKRC	0x11	/* Clocl control */
#define   CLK_EXT	    0x40	  /* Use external clock directly */
#define   CLK_SCALE	  0x3f	  /* Mask for internal clock scale */
#define REG_COM7	0x12	/* SCCB reset, output format */
#define   COM7_RESET	  0x80	  /* Register reset */
#define   COM7_FMT_MASK	  0x38
#define   COM7_FMT_VGA	  0x00
#define	  COM7_FMT_CIF	  0x20	  /* CIF format */
#define   COM7_FMT_QVGA	  0x10	  /* QVGA format */
#define   COM7_FMT_QCIF	  0x08	  /* QCIF format */
#define	  COM7_RGB	  0x04	  /* bits 0 and 2 - RGB format */
#define	  COM7_YUV	  0x00	  /* YUV */
#define	  COM7_BAYER	  0x01	  /* Bayer format */
#define	  COM7_PBAYER	  0x05	  /* "Processed bayer" */
#define REG_COM8	0x13	/* AGC/AEC options */
#define   COM8_FASTAEC	  0x80	  /* Enable fast AGC/AEC */
#define   COM8_AECSTEP	  0x40	  /* Unlimited AEC step size */
#define   COM8_BFILT	  0x20	  /* Band filter enable */
#define   COM8_AGC	  0x04	  /* Auto gain enable */
#define   COM8_AWB	  0x02	  /* White balance enable */
#define   COM8_AEC	  0x01	  /* Auto exposure enable */
#define REG_COM9	0x14	/* Control 9  - gain ceiling */
#define REG_COM10	0x15	/* Slave mode, HREF vs HSYNC, signals negate */
#define   COM10_HSYNC	  0x40	  /* HSYNC instead of HREF */
#define   COM10_PCLK_HB	  0x20	  /* Suppress PCLK on horiz blank */
#define   COM10_HREF_REV  0x08	  /* Reverse HREF */
#define   COM10_VS_LEAD	  0x04	  /* VSYNC on clock leading edge */
#define   COM10_VS_NEG	  0x02	  /* VSYNC negative */
#define   COM10_HS_NEG	  0x01	  /* HSYNC negative */
#define REG_HSTART	0x17	/* Horiz start high bits */
#define REG_HSTOP	0x18	/* Horiz stop high bits */
#define REG_VSTART	0x19	/* Vert start high bits */
#define REG_VSTOP	0x1a	/* Vert stop high bits */
#define REG_PSHFT	0x1b	/* Pixel delay after HREF */
#define REG_MIDH	0x1c	/* Manuf. ID high */
#define REG_MIDL	0x1d	/* Manuf. ID low */
#define REG_MVFP	0x1e	/* Mirror / vflip */
#define   MVFP_MIRROR	  0x20	  /* Mirror image */
#define   MVFP_FLIP	  0x10	  /* Vertical flip */
#define REG_BOS		0x20	  /* B channel Offset  */
#define REG_GBOS	0x21	/* Gb channel Offset  */
#define REG_GROS	0x22	/* Gr channel Offset  */
#define REG_ROS		0x23	  /* R channel Offset  */
#define REG_AEW		0x24	/* AGC upper limit */
#define REG_AEB		0x25	/* AGC lower limit */
#define REG_VPT		0x26	/* AGC/AEC fast mode op region */
#define REG_BBIAS	0x27	/* B channel output bias */
#define REG_GBBIAS	0x28	/* Gb channel output bias */
#define REG_GRCOM	0x29	/* Analog BLC & regulator */
#define REG_EXHCH	0x2A	/* Dummy pixel insert MSB */
#define REG_EXHCL	0x2B	/* Dummy pixel insert LSB */
#define REG_RBIAS	0x2C	/* R channel output bias */
#define REG_ADVFL	0x2D	/* LSB of dummy pixel insert in vertical direction 1 bit = 1 line */
#define REG_ADVFH	0x2E	/* MSB of dummy pixel insert in vertical direction 1 bit = 1 line */
#define REG_YAVE	0x2F	/* Y/G channel average value */
#define REG_HSYST	0x30	/* HSYNC rising edge delay LSB*/
#define REG_HSYEN	0x31	/* HSYNC falling edge delay LSB*/
#define REG_HREF	0x32	/* HREF pieces */
#define REG_CHLF	0x33	/* reserved */
#define REG_ADC	  0x37	/* reserved */
#define REG_ACOM	0x38	/* reserved */
#define REG_OFCON	0x39	/* Power down register */
#define 	OFCON_PWRDN	0x08	/* Power down bit */

#define REG_TSLB	0x3a	/* YUVU format */
#define   TSLB_YUYV_MASK	0x0c	  /* UYVY or VYUY - see com13 */

#define REG_COM11	0x3b	/* Night mode, banding filter enable */
#define   COM11_NIGHT	  0x80	  /* NIght mode enable */
#define   COM11_NMFR	  0x60	  /* Two bit NM frame rate */
#define   COM11_BANING	0x01    /* banding filter */
#define REG_COM12	0x3c	/* HREF option, UV average */
#define   COM12_HREF	  0x80	  /* HREF always */
#define REG_COM13	0x3d	/* Gamma selection, Color matrix enable, UV delay*/
#define   COM13_GAMMA	  0x80	  /* Gamma enable */
#define	  COM13_UVSAT	  0x40	  /* UV saturation auto adjustment */
#define   COM13_UVSWAP	  0x01	  /* V before U - w/TSLB */
#define REG_COM14	0x3e	/* Edge enhancement options */
#define REG_EDGE	0x3f	/* Edge enhancement factor */
#define REG_COM15	0x40	/* Output range, RGB 555 vs 565 option */
#define   COM15_R10F0	  0x00	  /* Data range 10 to F0 */
#define	  COM15_R01FE	  0x80	  /*            01 to FE */
#define   COM15_R00FF	  0xc0	  /*            00 to FF */
#define   COM15_RGB565	  0x10	  /* RGB565 output */
#define   COM15_RGB555	  0x30	  /* RGB555 output */
#define   COM15_SWAPRB	  0x04	  /* Swap R&B */
#define REG_COM16	0x41	/* Color matrix coeff double option */
#define   COM16_AWBGAIN   0x08	  /* AWB gain enable */
#define REG_COM17	0x42	/* Single Frame out, Banding filter */

/*
 * This matrix defines how the colors are generated, must be
 * tweaked to adjust hue and saturation.
 *
 * Order: v-red, v-green, v-blue, u-red, u-green, u-blue
 *
 * They are nine-bit signed quantities, with the sign bit
 * stored in 0x58.  Sign for v-red is bit 0, and up from there.
 */
#define	REG_CMATRIX_BASE 0x4f
#define   CMATRIX_LEN 9
#define	REG_CMATRIX_MTX1 0x4f
#define	REG_CMATRIX_MTX2 0x50
#define	REG_CMATRIX_MTX3 0x51
#define	REG_CMATRIX_MTX4 0x52
#define	REG_CMATRIX_MTX5 0x53
#define	REG_CMATRIX_MTX6 0x54
#define	REG_CMATRIX_MTX7 0x55
#define	REG_CMATRIX_MTX8 0x56
#define	REG_CMATRIX_MTX9 0x57

#define REG_CMATRIX_SIGN 0x58

#define REG_LCC1	0x62	/* Lens Correction Option 1 */
#define REG_LCC2	0x63	/* Lens Correction Option 2 */
#define REG_LCC3	0x64	/* Lens Correction Option 3 */
#define REG_LCC4	0x65	/* Lens Correction Option 4 */
#define REG_LCC5	0x66	/* Lens Correction Option 5 */
#define  LCC5_LCC_ENABLE 0x01 /* enable lens correction */
#define  LCC5_LCC_COLOR 0x04 /* Use LCC for green and LCCFB for rest, or just LCC */

#define REG_MANU	0x67	/* Manual U value, when TSLB[4] is high */
#define REG_MANV	0x68	/* Manual V value, when TSLB[4] is high */

#define REG_HV	0x69	/* Manual banding filter MSB */
#define REG_MBD	0x6a	/* Manual banding filter value, when COM11[0] is high */

#define REG_GSP	0x6c	/* Gamma 1 */
#define   GSP_LEN 15
#define REG_GSP	0x6c	/* Gamma 1 */
#define   GST_LEN 14

#define REG_COM22	0x8c	/* Edge enhancement, denoising */
#define   COM22_WHTPCOR	  0x02	  /* White pixel correction enable */
#define   COM22_WHTPCOROPT	 0x01	  /* White pixel correction option */
#define   COM22_DENOISE	 0x10	  /* White pixel correction option */
#define REG_COM23	0x8d	/* Color bar test,color gain */

#define REG_DBLC1	0x8f	/* Digital BLC */
#define REG_DBLC_B	0x90	/* Digital BLC B chan offset */
#define REG_DBLC_R	0x91	/* Digital BLC R chan offset */
#define REG_DM_LNL	0x92	/* Dummy line low 8 bits */
#define REG_DM_LNH	0x93	/* Dummy line high 8 bits */


#define REG_LCCFB	0x9d	/* Lens Correction B chan */
#define REG_LCCFR	0x9e	/* Lens Correction R chan */

#define REG_DBLC_GB	0x9f	/* Digital BLC GB chan offset */
#define REG_DBLC_GR	0xa0	/* Digital BLC GR chan offset */

#define REG_AECHM	0xa1	/* Exposure Value - AEC MSB 6 bits */
#define REG_BD50ST	0xa2	/* Banding Filter Value 50Hz */
#define REG_BD60ST	0xa3	/* Banding Filter Value 60Hz */

    REG_COM7,0x80, /*  SCCB reset, output format  */
    REG_OFCON,0x43, /*  Power down register  */
    REG_ACOM,0x12, /*  reserved  */
    REG_ADC,0x91, /*  reserved  */
//    REG_COM5,(1<<7), /*  System clock options  */
  //
//    REG_MVFP,0x0c, /*  Mirror / vflip  */
    REG_BLUE,0x80, /*  blue gain  */
    REG_RED,0x80, /*  red gain  */
    REG_GAIN,0x00, /*  Gain lower 8 bits (rest in vref)  */
    REG_AEC,0xf0, /*  More bits of AEC value  */
    REG_COM1,0x00, /*  Control 1  */
    REG_COM3,0x04, /*  Output byte swap, signals reassign  */
    REG_COM4,0x80, /*  Vario Pixels   */
  	
    REG_CLKRC,0x80, /*  Clock control, try to run at 24Mhz  */
  	
    REG_COM7,0x10, /*  SCCB reset, output format  */
    REG_COM9,0x2e, /*  Control 9  - gain ceiling  */
    REG_COM10,0x00, /*  Slave mode, HREF vs HSYNC, signals negate  */
  	
  	
    REG_HSTART,0x1d+8, /*  Horiz start high bits  */
    REG_HSTOP,0xbd+8, /*  Horiz stop high bits  */
    REG_HREF,0xbf, /*  HREF pieces  */
  	
    REG_VSTART,0x00, /*  Vert start high bits  */
    REG_VSTOP,0x80, /*  Vert stop high bits  */
    REG_VREF,0x12, /*  Pieces of GAIN, VSTART, VSTOP  */
  	
    REG_EDGE,0xa6, /*  Edge enhancement factor  */
    REG_COM16,0x02, /*  Color matrix coeff double option  */
    REG_COM17,0x08, /*  Single Frame out, Banding filter  */
    REG_PSHFT,0x00, /*  Pixel delay after HREF  */
    0x16,0x06,
    REG_CHLF,0xc0, /*  reserved  */
    0x34,0xbf,
    0xa8,0x80,
    0x96,0x04,
    REG_TSLB,0x00, /*  YUVU format  */
    0x8e,0x00,
    REG_COM12,0x77, /*  HREF option, UV average  */
  
    0x8b,0x06,
    0x35,0x91,
    0x94,0x88,
    0x95,0x88,
    REG_COM15,0xc1, /*  Output range, RGB 555 vs 565 option  */
  
    REG_GRCOM,0x3f, /*  Analog BLC & regulator  */
    REG_COM6,0x42, /*  HREF & ADBLC options  */
    REG_COM8,0xe5, /*  AGC/AEC options  */
    REG_COM13,0x92, /*  Gamma selection, Color matrix enable, UV delay */
    REG_HV,0x80, /*  Manual banding filter MSB  */
  
    0x5c,0x96,
    0x5d,0x96,
    0x5e,0x10,
    0x59,0xeb,
    0x5a,0x9c,
    0x5b,0x55,
    0x43,0xf0,
    0x44,0x10,
    0x45,0x55,
    0x46,0x86,
    0x47,0x64,
    0x48,0x86,
    0x5f,0xe0,
    0x60,0x8c,
    0x61,0x20,
    0xa5,0xd9,
    0xa4,0x74,
    REG_COM23,0x02, /*  Color bar test,color gain  */
    REG_COM8,(1<<5), /*  AGC/AEC options  */
    0x4f,0x3a,
  //0xe7
    0x50,0x3d,
    0x51,0x03,
    0x52,0x12,
    0x53,0x26,
    0x54,0x38,
    0x55,0x40,
    0x56,0x40,
    0x57,0x40,
    0x58,0x0d,
    REG_COM22,0x23, /*  Edge enhancement, denoising  */
    REG_COM14,0x02, /*  Edge enhancement options  */
    0xa9,0xb8,
    0xaa,0x92,
    0xab,0x0a,
    REG_DBLC1,0xdf, /*  Digital BLC  */
    REG_DBLC_B,0x00, /*  Digital BLC B chan offset  */
    REG_DBLC_R,0x00, /*  Digital BLC R chan offset  */
    REG_DBLC_GB,0x00, /*  Digital BLC GB chan offset  */
    REG_TSLB,0x0c, /*  YUVU format  */
    REG_AEW,0x70, /*  AGC upper limit  */
    REG_AEB,0x64, /*  AGC lower limit  */
    REG_VPT,0xc3, /*  AGC/AEC fast mode op region  */
    REG_EXHCH,0x00, /*  Dummy pixel insert MSB  */
    REG_EXHCL,0x00, /*  Dummy pixel insert LSB  */
    REG_COM11,(1<<7)|(3<<5), /*  Night mode, banding filter enable  */
  //0x2a,0x12 0x19
    REG_GSP,0x40, /*  Gamma 1  */
    0x6d,0x30,
    0x6e,0x4b,
    0x6f,0x60,
  
    0x70,0x70,
    0x71,0x70,
    0x72,0x70,
    0x73,0x70,
    0x74,0x60,
    0x75,0x60,
    0x76,0x50,
    0x77,0x48,
    0x78,0x3a,
    0x79,0x2e,
    0x7a,0x28,
    0x7b,0x22,
    0x7c,0x04,
    0x7d,0x07,
    0x7e,0x10,
    0x7f,0x28,
    0x80,0x36,
    0x81,0x44,
    0x82,0x52,
    0x83,0x60,
    0x84,0x6c,
    0x85,0x78,
    0x86,0x8c,
    0x87,0x9e,
    0x88,0xbb,
    0x89,0xd2,
    0x8a,0xe6,
    REG_MBD,0x41, /*  Manual banding filter value, when COM11[0] is high  */
    REG_LCC5,0x00, /*  Lens Correction Option 5  */
    REG_COM14,0x00, /*  Edge enhancement options  */
    REG_EDGE,0xa4,
  #else	
	0x3, 0x6, //0x80,			// turn on QVGA
	0x3, 0x6, //0x80,			// turn on QVGA
  #endif	
	-1};


void camera_setup (void) {
	int bb;
	int *ptREG;

// this Falcon requires ALL SCU_CLK to be set to EMC_CLK* when SDRAM is used --  "feature"	
//    LPC_SCU_CLK(2) = 1 + (MD_PLN | MD_EZI | MD_ZI | MD_EHS); /* SFSCLK2: EXTBUS_CLK2  (CLKOUT function , from datasheet) */
//
	scu_pinmux(1, 19, MD_PUP, FUNC4);		// CLKOUT    
	CGU_EntityConnect(CGU_CLKSRC_IDIVE, CGU_BASE_CLKOUT);

//  LCDPWR pin connected to reset (pulled high on startup, driven low as GPIO to un-reset the Toshiba cam	
	scu_pinmux(0x7,7,  MD_PUP, FUNC0); 				//  GPIO3[15]

	LPC_GPIO_PORT->DIR[3] = (1<<15);
	LPC_GPIO_PORT->CLR[3] = (1<<15);				// drive RESET to tosh-camera low
	for (bb=0;bb<10000;bb++);							// hold it low 2000 clocks
	LPC_GPIO_PORT->SET[3] = (1<<15);				// drive RESET to tosh-camera high


	/* I2C block ------------------------------------------------------------------- */
	// Initialize Slave I2C peripheral
	I2C_Init(I2CDEV_M, 100000);
			
	ptREG = camREGs;

while(1) {
for(bb=0; bb<40000; bb++);
	
	if (*ptREG <0) break;		// done writing initialization parameters
	I2C_Write(I2CDEV_M, I2C_SLAVE_ADDR, *ptREG++, *ptREG++);
}

	
}

