#ifndef	__BREAKPOINT
#define	__BREAKPOINT
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//
//		simple debug stuff



/* Macro to define control bit */
#define UART_LCR_DLAB_EN        ((uint8_t)(1<<7))   /* DivisorLatchesAccess enable*/
#define UART_FCR_FIFO_EN        ((uint8_t)(1<<0))   /* FIFO enable */
#define UART_FCR_RX_RS          ((uint8_t)(1<<1))   /* FIFO RX reset */
#define UART_FCR_TX_RS          ((uint8_t)(1<<2))   /* FIFO TX reset */
#define UART_TER_TXEN           ((uint8_t)(1<<7))   /* Transmit enable bit */
#define UART_ACR_START          ((uint32_t)(1<<0))  /* Auto baudrate Start */
#define UART_ACR_ABEOINT_CLR    ((uint32_t)(1<<8))  /* Auto baudrate end INT clear */
#define UART_ACR_ABTOINT_CLR    ((uint32_t)(1<<9))  /* Auto baudrate Ttime-out INT clear */

#define UART_CFG_DATABIT_8   ((uint8_t)(3<<0))    /* UART 8 bit data mode */
#define UART_CFG_STOPBIT_1   ((uint8_t)(0))      /* UART 1 Stop Bits Select */
#define UART_CFG_PARITY_NONE   ((uint8_t)(0))     /* No parity */

#define UART_FCR_FIFO_EN        ((uint8_t)(1<<0))   /* FIFO enable */
#define UART_CFG_FIFOTRG_8   ((uint8_t)(2<<6)) /* UART FIFO trigger level 2: 8 char */

#define UART_LS_TX_EMPTY_ALL  ((uint8_t)(1<<6)) /*Transmitter THR and TSR all empty*/


#define CR 			0xD
#define LF 			0xA
#define XON 		0x11
#define XOFF		0x13
#define BACKSPACE	0x8
#define SPACE		0x20
#define TAB	 		0x09
#define ESC	 		27				//these 2 will stop the interpreter in serial mode
#define CTRLC 		3
#define EOTX 		4				//sent back when program finishes
#define SOH 		1				//sent back when program starts




#define outbyte putchar
#define printf  _embedded_printf
#define sprintf	_embedded_sprintf

void breakpoint(void) ;
void helpscreen(void) ;
void UART_init(void) ;

#endif		//	__BREAKPOINT

