
#include "LPC43xx.h"                    /* LPC43xx Definitions                */
#include "i2c.h"
#include "SGPIOcamera.h"

//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//
//		capture an image

#define SGPIO_PIN_SET			(1<<6)		// scu setting for slew rate, glitch...
#define  GPIO_PIN_SET			(1<<6)		// scu setting for slew rate, glitch...
extern int col;
extern int row;
extern int OneFrameDone;
int OneFrameBegin=0;

void setup_SGPIO_image_capture(void) {
	
    LPC_SGPIO->CLR_EN_0	= 0xffff;		// disable interrupting on clock
    LPC_SGPIO->CLR_EN_1	= 0xffff;		// disable interrupting on clock

	/* Disable all counters (should be in this state after reset but just make sure) */
	LPC_SGPIO->CTRL_ENABLE = 0;	

	/* Set all pins as input */
	LPC_SGPIO->GPIO_OENREG = 0;
	
#define INV_OUT_CLK   (1<<3)

#define CONCAT_ENABLE (1<<11)
#define SLICE_2		  (1<<12)
#define SLICE_4		  (2<<12)
#define SLICE_8		  (3<<12)	

#define BIT_MODE	  (0<<6)
#define BIT2_MODE	  (1<<6)
#define NIBBLE_MODE	  (2<<6)
#define BYTE_MODE	  (3<<6)

#define CLKGEN_EXT		(1<<2)

#define EXT_CLK_SGPIO8	0x01
#define EXT_CLK_SGPIO9	0x03
#define EXT_CLK_SGPIO10	0x05
#define EXT_CLK_SGPIO11	0x07

#define EXT_QUAL_SGPIO8		((3<<5) | (0<<7))
#define EXT_QUAL_SGPIO9		((3<<5) | (1<<7))
#define EXT_QUAL_SGPIO10	((3<<5) | (2<<7))
#define EXT_QUAL_SGPIO11	((3<<5) | (3<<7))

////////////////////////////////////////////////////////////////////////////////
//
//	set all the clocks to the same frequency
//


	
	LPC_SGPIO->PRESET[0]  = 				
	LPC_SGPIO->PRESET[8]  = 				
	LPC_SGPIO->PRESET[4]  = 				
	LPC_SGPIO->PRESET[9]  = 				
	LPC_SGPIO->PRESET[2]  = 
	LPC_SGPIO->PRESET[10] = 			
	LPC_SGPIO->PRESET[5]  = 
	LPC_SGPIO->PRESET[11] = 0;		// 8 slice buffer
		
	/* Load counter with initial value */

	LPC_SGPIO->COUNT[0]  =				// clock
	LPC_SGPIO->COUNT[8]  =				
	LPC_SGPIO->COUNT[4]  =	
	LPC_SGPIO->COUNT[9]  =			
	LPC_SGPIO->COUNT[2]  =
	LPC_SGPIO->COUNT[10] = 			
	LPC_SGPIO->COUNT[5]  =
	LPC_SGPIO->COUNT[11] = 0;		// 8 slice buffer 
	
	
	
	/*************************************/
	/* Program slice A(0) as pixel buffer */
	/*************************************/

	LPC_SGPIO->SLICE_MUX_CFG[0]  = 	
	LPC_SGPIO->SLICE_MUX_CFG[8]  = 	
	LPC_SGPIO->SLICE_MUX_CFG[4]  = 	
	LPC_SGPIO->SLICE_MUX_CFG[9]  = 	
	LPC_SGPIO->SLICE_MUX_CFG[2]  = 	
	LPC_SGPIO->SLICE_MUX_CFG[10] = 	
	LPC_SGPIO->SLICE_MUX_CFG[5]  = 	
	LPC_SGPIO->SLICE_MUX_CFG[11] =  CLKGEN_EXT  |  BYTE_MODE;	
	
	LPC_SGPIO->SGPIO_MUX_CFG[0]  =                 SLICE_8   | EXT_CLK_SGPIO8 | EXT_QUAL_SGPIO9   ;	 // inputs from data pin
	LPC_SGPIO->SGPIO_MUX_CFG[8]  = 	
	LPC_SGPIO->SGPIO_MUX_CFG[4]  = 	
	LPC_SGPIO->SGPIO_MUX_CFG[9]  = 	
	LPC_SGPIO->SGPIO_MUX_CFG[2]  = 	
	LPC_SGPIO->SGPIO_MUX_CFG[10] = 	
	LPC_SGPIO->SGPIO_MUX_CFG[5]  = 	
	LPC_SGPIO->SGPIO_MUX_CFG[11] = CONCAT_ENABLE | SLICE_8   | EXT_CLK_SGPIO8 | EXT_QUAL_SGPIO9   ;	
	
	LPC_SGPIO->POS[0]  = 	
	LPC_SGPIO->POS[8]  = 	
	LPC_SGPIO->POS[4]  = 	
	LPC_SGPIO->POS[9]  = 	
	LPC_SGPIO->POS[2]  = 	
	LPC_SGPIO->POS[10] = 	
	LPC_SGPIO->POS[5]  = 	
	LPC_SGPIO->POS[11] = ((0x020-1)<<8) | (0x020-1);
	
	
/////////////////////////////////////////////////////////	

	// watch the slice clock --
			
//	LPC_SGPIO->OUT_MUX_CFG[13]  = 8;	// clockout from slice J
//	scu_pinmux(0x1 ,20, MD_PUP, FUNC6);	//  SGPIO13: -- SV3.9	
//  LPC_SCU->SFSP1_20  = SGPIO_PIN_SET | 6;  /* P1_20:  SGPIO13                    */

	LPC_SGPIO->GPIO_OENREG |= (1<<13);
	
	
/////////////////////////////////////////////////////////////////////////////////
	/* Enable counter under test to start pixel stream generation */
	LPC_SGPIO->CTRL_ENABLE = (1<<0) | (1<<8) | (1<<4) | (1<<9)
							| (1<<2) | (1<<10) | (1<<5) | (1<<11) ;
							
	

// and SGPIO pins
///////////////////////////// setup SGPIO ///////////////////
//
//	handle the pin mux setup for SGPIO
//
	/* validation board with 256BGA */
	
// pixel inputs bit 7 is MSB	

//	scu_pinmux(0x9 ,0 , MD_EZI | MD_PUP, FUNC6);	//  SGPIO0: -- SV11.4	
//	scu_pinmux(0x9 ,1 , MD_EZI | MD_PDN, FUNC6);	//  SGPIO1: -- SV13.4	
//	scu_pinmux(0x9 ,2 , MD_EZI | MD_PUP, FUNC6);	//  SGPIO2: -- SV15.4
//	scu_pinmux(0x9 ,5 , MD_EZI | MD_PDN, FUNC6);	//  SGPIO3: -- SV5.4	
//	scu_pinmux(0x6 ,3 , MD_EZI | MD_PUP, FUNC2);	//  SGPIO4: -- SV5.2
//	scu_pinmux(0x7 ,1 , MD_EZI | MD_PDN, FUNC7);	//  SGPIO5: -- X11.22	
//	scu_pinmux(0xf ,7 , MD_EZI | MD_PUP, FUNC6);	//  SGPIO6: -- X5.18
//	scu_pinmux(0xf ,8 , MD_EZI | MD_PDN, FUNC6);	//  SGPIO7: -- X5.20	
	
  LPC_SCU->SFSP9_0  = SGPIO_PIN_SET | 6;  /* P9_0:  SGPIO0                    */
  LPC_SCU->SFSP9_1  = SGPIO_PIN_SET | 6;  /* P9_1:  SGPIO1                    */
  LPC_SCU->SFSP9_2  = SGPIO_PIN_SET | 6;  /* P9_2:  SGPIO2                    */
  LPC_SCU->SFSP9_5  = SGPIO_PIN_SET | 6;  /* P9_5:  SGPIO3                    */
  LPC_SCU->SFSP6_3  = SGPIO_PIN_SET | 2;  /* P6_3:  SGPIO4                    */
  LPC_SCU->SFSP6_6  = SGPIO_PIN_SET | 2;  /* P6_6:  SGPIO5                    */
  LPC_SCU->SFSPF_7  = SGPIO_PIN_SET | 6;  /* PF_7:  SGPIO6                    */
  LPC_SCU->SFSPF_8  = SGPIO_PIN_SET | 6;  /* PF_8:  SGPIO7                    */
	

//  clkin pin
  //LPC_SCU->SFSP8_0  = SGPIO_PIN_SET | 4;  /* P8_0:  SGPIO8       pixel clock   -- loaded heavily by MCB4300 PBC */
  LPC_SCU->SFSP9_6  = SGPIO_PIN_SET | 6;  /* P9_6:  SGPIO8       pixel clock             */

//  clk qualifier pin -- HREF
  LPC_SCU->SFSP8_1  = SGPIO_PIN_SET | 4;  /* P8_1:  SGPIO9   pixel qualifier                 */
	
//  VREF sync up on a frame here	
  LPC_SCU->SFSP1_20  = SGPIO_PIN_SET | 0;  /* P1_20:  GPIO0[15]  VREF                  */
	
}



/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////

// By assigning some local pointers to the following macros and the writes to the shadow register
// and looking at the resultant assembly code what was originally marginal at 25 MHz now runs up past 30 MHz (marginal at 35)

#define	sgpio_wait4reload 				while ((sgpio_status1[0] & 1) == 0);
#define sgpio_clear_status				sgpio_status1[1] = 0x0001			 // clear A slice -- capture clock status


#ifdef CAM130
  #define I2C_SLAVE_ADDR	0x60
#else
  #define I2C_SLAVE_ADDR	0x78		// Toshiba camera
#endif


#define CAM_BUF_START	0x28040000
#define LCD_BUF_START	0x28000000

#define CAM_WIDTH	320
#define CAM_HEIGHT	240

#define LCD_WIDTH  	240
#define LCD_HEIGHT 	320

#define TIMEOUT 100000

void pixel_test(void)	{		// test routine to fill memory -- not called anywhere, use Keil to launch it
	int *pixelPTR = (int *) LCD_BUF_START;  
	int i,pxl;
	
	pxl=0xf000f000;		// patch this to test different values
	*pixelPTR = pxl;
	
	for (i=0; i<4000; i++) {
		*pixelPTR++ = pxl;
	}
	
 #ifdef USE_BREAKPOINT	
	breakpoint();
 #endif
	while(1);
}


void copy_image(void) {		// the LCD is portrait mode, but camera is landscape so we have to copy the data 16 bits at a time to the right place
	int rowL,colL;
	
	short *lcdPTR;
	short *pixelPTR;  
	short x;

	for (rowL=0; rowL<CAM_HEIGHT; rowL++) {				
		lcdPTR = (short *) 		(LCD_BUF_START + (rowL<<1));
	 	pixelPTR = (short *)	(CAM_BUF_START + 2*CAM_WIDTH*rowL);  
		for (colL=0; colL<CAM_WIDTH; colL++) {
			x = *pixelPTR;
										// x used to check pixel bit swaps
//			x = (x & 0x3f3f) | ((x & 0x8080)>>1) | ((x & 0x4040)<<1);
//			x = (x & 0x5f5f) | ((x & 0x8080)>>2) | ((x & 0x2020)<<2);
// 			x = (x & 0x6f6f) | ((x & 0x8080)>>3) | ((x & 0x1010)<<3);
// 			x = (x & 0x7777) | ((x & 0x8080)>>4) | ((x & 0x0808)<<4);
// 			x = (x & 0x7b7b) | ((x & 0x8080)>>5) | ((x & 0x0404)<<5);
// 			x = (x & 0x7d7d) | ((x & 0x8080)>>6) | ((x & 0x0202)<<6);
// 			x = (x & 0x7e7e) | ((x & 0x8080)>>7) | ((x & 0x0101)<<7);

//			x = (x & 0x9f9f) | ((x & 0x4040)>>1) | ((x & 0x2020)<<1);
//			x = (x & 0xafaf) | ((x & 0x4040)>>2) | ((x & 0x1010)<<2);
//			x = (x & 0xb7b7) | ((x & 0x4040)>>3) | ((x & 0x0808)<<3);
//			x = (x & 0xbbbb) | ((x & 0x4040)>>4) | ((x & 0x0404)<<4);
//			x = (x & 0xbdbd) | ((x & 0x4040)>>5) | ((x & 0x0202)<<5);
//			x = (x & 0xbebe) | ((x & 0x4040)>>6) | ((x & 0x0101)<<6);
			
//			x = (x & 0xcfcf) | ((x & 0x2020)>>1) | ((x & 0x1010)<<1);
//			x = (x & 0xd7d7) | ((x & 0x2020)>>2) | ((x & 0x0808)<<2);
//			x = (x & 0xdbdb) | ((x & 0x2020)>>3) | ((x & 0x0404)<<3);
//			x = (x & 0xdddd) | ((x & 0x2020)>>4) | ((x & 0x0202)<<4);
//			x = (x & 0xdede) | ((x & 0x2020)>>5) | ((x & 0x0101)<<5);

//			x = (x & 0xe7e7) | ((x & 0x1010)>>1) | ((x & 0x0808)<<1);
//			x = (x & 0xebeb) | ((x & 0x1010)>>2) | ((x & 0x0404)<<2);
//			x = (x & 0xeded) | ((x & 0x1010)>>3) | ((x & 0x0202)<<3);
//			x = (x & 0xeeee) | ((x & 0x1010)>>4) | ((x & 0x0101)<<4);

//			x = (x & 0xf3f3) | ((x & 0x0808)>>1) | ((x & 0x0404)<<1);
//			x = (x & 0xf5f5) | ((x & 0x0808)>>2) | ((x & 0x0202)<<2);
//			x = (x & 0xf6f6) | ((x & 0x0808)>>3) | ((x & 0x0101)<<3);

//			x = (x & 0xf9f9) | ((x & 0x0404)>>1) | ((x & 0x0202)<<1);
//			x = (x & 0xfafa) | ((x & 0x0404)>>2) | ((x & 0x0101)<<2);
			
//			x = (x & 0xfcfc) | ((x & 0x0202)>>1) | ((x & 0x0101)<<1);
			
//			x &= 0xF800;		// red
//			x &= 0x07e0;		// green
//			x &= 0x001f;		// blue
			
			*lcdPTR = x;
			lcdPTR += 240;
			pixelPTR++;
		}
	}
}

void capture_image(void) {
	int timeout;

	volatile unsigned int *sgpio_status1 = (volatile unsigned int *)&LPC_SGPIO->STATUS_1;
	
	// need to check for I2C0 vs I2C1 here, but these pins are not multipurpose anywat
	if(OneFrameBegin==0)
	{

	I2C_Write(LPC_I2C0, I2C_SLAVE_ADDR, 0x3, 0x6);	// camera hangs up, so this helps keep it running
	
	timeout = TIMEOUT;
	while ((LPC_GPIO_PORT->PIN[0] & (1 << 15)) == 0) {if (--timeout == 0) return;};
	timeout = TIMEOUT;
	while ( LPC_GPIO_PORT->PIN[0] & (1 << 15))       {if (--timeout == 0) return;};

	LPC_SGPIO->POS[0]  = 	
	LPC_SGPIO->POS[8]  = 	
	LPC_SGPIO->POS[4]  = 	
	LPC_SGPIO->POS[9]  = 	
	LPC_SGPIO->POS[2]  = 	
	LPC_SGPIO->POS[10] = 	
	LPC_SGPIO->POS[5]  = 	
	LPC_SGPIO->POS[11] = ((0x020-1)<<8) | (0x020-1);	// make sure the POS pointers start at "0"

	sgpio_clear_status;		// empty buffers at the beginning of a frame
	OneFrameBegin=1;
	
	LPC_SGPIO->SET_EN_1 = 0x0001;					//interrupt when slice 0 switches data register
}
/*
	for (row=0; row<CAM_HEIGHT; row++) {				

		for (col=0; col<CAM_WIDTH; col += 16) {
			
//			sgpio_wait4reload;
			timeout = TIMEOUT;
			while ((sgpio_status1[0] & 1) == 0) {if (--timeout == 0) return;};

			sgpio_clear_status;				
			
			*pixelPTR++ = sgpio_shadow[11] ;
			*pixelPTR++ = sgpio_shadow[5]  ;
			*pixelPTR++ = sgpio_shadow[10] ;
			*pixelPTR++ = sgpio_shadow[2]  ;
			*pixelPTR++ = sgpio_shadow[9]  ;
			*pixelPTR++ = sgpio_shadow[4]  ;
			*pixelPTR++ = sgpio_shadow[8]  ;
			*pixelPTR++ = sgpio_shadow[0]  ;
			
		}
		pixelPTR = (int *) (CAM_BUF_START + 2 * CAM_WIDTH * row);
	}
*/
if(OneFrameDone==1)
{
	LPC_SGPIO->CLR_EN_1	= 0xffff;							//And clear the interrupt
//	NVIC_DisableIRQ(SGPIO_IRQn);        			//Enable SGPIO Interrupt
//	LPC_SGPIO->SET_EN_1 = 0x0000;					//interrupt when slice 0 switches data register
	copy_image();		// convert landscape to portrait
	OneFrameBegin=0;
	OneFrameDone=0;
}
	
}

void loop_capture_image(void) {
	while (1)
		capture_image();
}


//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//
//		Camera setup, including i2c register programming


#define I2CDEV_M LPC_I2C0


//	pairs of register addresses and values to be written via i2c to camera chip for initialization, terminated by -1
int  camREGs[] = {
	0x3, 0x6, //0x80,			// turn on QVGA
	0x3, 0x6, //0x80,			// turn on QVGA
	-1};


void camera_setup (void) {
	int bb;
	int *ptREG;
	
	LPC_SCU->SFSP1_20  = (1<<6) | 0;  /* P1_20:  GPIO0[15]       VSYNC pin             */
	LPC_SCU->SFSP1_17  = (1<<6) | 0;  /* P1_17:  GPIO0[12]       reset pin             */

	LPC_GPIO_PORT->DIR[0] |= (1<<12);
	LPC_GPIO_PORT->CLR[0] =  (1<<12);				// drive RESET to tosh-camera low
	for (bb=0;bb<10000;bb++);							// hold it low 2000 clocks
	LPC_GPIO_PORT->SET[0] =  (1<<12);				// drive RESET to tosh-camera high
	
	
	/* I2C block ------------------------------------------------------------------- */
	// Initialize Slave I2C peripheral
	I2C_Init(I2CDEV_M, 100000);
			
	ptREG = camREGs;

	while(1) {
		for(bb=0; bb<40000; bb++);
	
	if (*ptREG <0) break;		// done writing initialization parameters
	I2C_Write(I2CDEV_M, I2C_SLAVE_ADDR, *ptREG++, *ptREG++);
	}
}

