
#include "LPC213x.h"

extern void SPI0_Init(void);

extern unsigned char SlaveRcv;
extern unsigned char SlaveSnd;


static unsigned char ADC_Read(void)
{
  unsigned int i;

    AD0CR  = 0x00200302;                   // Init ADC (Pclk = 12MHz) and select channel AD0.1
    AD0CR |= 0x01000000;                   // Start A/D Conversion
    do
    {
        i = AD0DR;                         // Read A/D Data Register
    } while ((i & 0x80000000) == 0);       // Wait for end of A/D Conversion

    return (i >> 8) & 0x00FF;              // bit 8:15 is 8-bit AD value
}

void main()
{
    PINSEL1 |= 0x01000000;                 // P0.28 = AD0.1
    IODIR1   = 0x00FF0000;                 // P1.16..23 defined as Outputs
    SPI0_Init();                           // initialize SPI bus

    while (1)
    {
        IOCLR1 = 0x00FF0000;               // Turn off LEDs
        IOSET1 = SlaveRcv << 16;           // Turn on LEDs

        SlaveSnd = ADC_Read();             // convert and send channel AD0.1
    }
}
