
#include "LPC213x.h"

unsigned char SlaveRcv = 0xAA;
unsigned char SlaveSnd;


void SPI0_Isr(void) __irq
{
    if (S0SPSR) ;                  // (dummy) read status register

    SlaveRcv = S0SPDR;             // read data received
    S0SPDR   = SlaveSnd;           // next data to transmit

    S0SPINT  = 0x01;               // reset interrupt flag
    VICVectAddr = 0;               // reset VIC
}

void SPI0_Init(void)
{
    PINSEL0 |= 0x00005500;         // configure SPI0 pins
    S0SPCR   = 0x88;               /* 1000 1000     Initialize SPI hardware:
                                      |||| ||||
                                      |||| | -----> reserved
                                      ||||  ------> SPI clock phase select
                                      ||| --------> SPI clock polarity = low when idle
                                      || ---------> SPI slave mode
                                      | ----------> SPI data order = msb first
                                       -----------> SPI interrupt enabled        */

    VICVectAddr0  = (unsigned int) &SPI0_Isr;
    VICVectCntl0  = 0x2A;          // Channel0 on Source#10 ... enabled
    VICIntEnable |= 0x400;         // 10th bit is SPI0 interface
}