
#include "type.h"

#include "usb.h"
#include "hid.h"
#include "usbcfg.h"
#include "usbdesc.h"


const BYTE HID_ReportDescriptor[] =            // HID Report Descriptor
{
    HID_UsagePageVendor(0x00),                             // 0x06,x,0xFF
    HID_Usage(0x01),                                       // 0x09,x
    HID_Collection(HID_Application),                       // 0xA1,01

// ** Input report
    HID_Usage(3),                                          // 0x09,x
    HID_LogicalMin(0),                                     // 0x15,x
    HID_LogicalMax(255),                                   // 0x25,x
    HID_ReportCount(1),                                    // 0x95,x
    HID_ReportSize(8),                                     // 0x75,x
    HID_Input(HID_Data | HID_Variable | HID_Absolute),     // 0x81,x

// ** Output report
    HID_Usage(4),                                          // 0x09,x
    HID_LogicalMin(0),                                     // 0x15,x
    HID_LogicalMax(255),                                   // 0x25,x
    HID_ReportCount(3),                                    // 0x95,x
    HID_ReportSize(8),                                     // 0x75,x
    HID_Output(HID_Data | HID_Variable | HID_Absolute),    // 0x91,x

    HID_EndCollection,                                     // 0xC0
};

const WORD HID_ReportDescSize = sizeof(HID_ReportDescriptor);


const BYTE USB_DeviceDescriptor[] =        // USB Standard Device Descriptor
{
    USB_DEVICE_DESC_SIZE,                  // bLength :        18 bytes
    USB_DEVICE_DESCRIPTOR_TYPE,            // bDescriptorType: 1
    WBVAL(0x0110),                         // bcdUSB:          1.1
    0x00,                                  // bDeviceClass
    0x00,                                  // bDeviceSubClass
    0x00,                                  // bDeviceProtocol
    USB_MAX_PACKET0,                       // bMaxPacketSize0: 8
    WBVAL(0x04CC),                         // idVendor NXP:    0x04CC
    WBVAL(0x0801),                         // idProduct
    WBVAL(0x0100),                         // bcdDevice:       1.00
    0x04,                                  // iManufacturer
    0x16,                                  // iProduct
    0x36,                                  // iSerialNumber
    0x01                                   // bNumConfigurations
};

const BYTE USB_ConfigDescriptor[] =        // USB Configuration Descriptor
{
    USB_CONFIGURATION_DESC_SIZE,           // bLength:         9 bytes
    USB_CONFIGURATION_DESCRIPTOR_TYPE,     // bDescriptorType: 2
    WBVAL(                                 // wTotalLength
      USB_CONFIGURATION_DESC_SIZE +        // 9 +
      USB_INTERFACE_DESC_SIZE     +        // 9 +
      HID_DESC_SIZE               +        // 9 +
      USB_ENDPOINT_DESC_SIZE               // 7 = 34 (0x22)
    ),
    0x01,                                  // bNumInterfaces
    0x01,                                  // bConfigurationValue
    0x00,                                  // iConfigurationString
    USB_CONFIG_BUS_POWERED,                // bmAttributes
    USB_CONFIG_POWER_MA(100),              // bMaxPower

                                           // Interface Descriptor
    USB_INTERFACE_DESC_SIZE,               // bLength:         9 bytes
    USB_INTERFACE_DESCRIPTOR_TYPE,         // bDescriptorType: 4
    0x00,                                  // bInterfaceNumber
    0x00,                                  // bAlternateSetting
    0x01,                                  // bNumEndpoints
    USB_DEVICE_CLASS_HUMAN_INTERFACE,      // bInterfaceClass: 3
    HID_SUBCLASS_NONE,                     // bInterfaceSubClass: 0
    HID_PROTOCOL_NONE,                     // bInterfaceProtocol: 0
    0x40,                                  // iInterfaceString

                                           // HID Class Descriptor
    HID_DESC_SIZE,                         // bLength:         9 bytes
    HID_HID_DESCRIPTOR_TYPE,               // bDescriptorType: 0x21
    WBVAL(0x0100),                         // bcdHID:          1.00
    0x00,                                  // bCountryCode
    0x01,                                  // bNumDescriptors
    HID_REPORT_DESCRIPTOR_TYPE,            // bDescriptorType: 0x22
    WBVAL(HID_REPORT_DESC_SIZE),           // wDescriptorLength

                                           // Endpoint, HID Interrupt In
    USB_ENDPOINT_DESC_SIZE,                // bLength:          7 bytes
    USB_ENDPOINT_DESCRIPTOR_TYPE,          // bDescriptorType:  5
    USB_ENDPOINT_IN(1),                    // bEndpointAddress: 0x81
    USB_ENDPOINT_TYPE_INTERRUPT,           // btransferType:    interrupt
    WBVAL(0x0004),                         // wMaxPacketSize
    0x20,                                  // bInterval:        32ms

    0                                      // Terminator
};

const BYTE USB_StringDescriptor[] =        // USB String Descriptor (optional)
{
/* Index 0x00: LANGID Codes */
    0x04,                                  // bLength
    USB_STRING_DESCRIPTOR_TYPE,            // bDescriptorType
    WBVAL(0x0409),                         // wLANGID US English
/* Index 0x04: Manufacturer */
    0x12,                                  // bLength
    USB_STRING_DESCRIPTOR_TYPE,            // bDescriptorType
    'N',0,
    'X',0,
    'P',0,
    ' ',0,
    'M',0,
    'A',0,
    'C',0,
    'C',0,
/* Index 0x16: Product */
    0x20,                                  // bLength
    USB_STRING_DESCRIPTOR_TYPE,            // bDescriptorType
    'N',0,
    'X',0,
    'P',0,
    ' ',0,
    'D',0,
    'M',0,
    'X',0,
    '5',0,
    '1',0,
    '2',0,
    ' ',0,
    'D',0,
    'E',0,
    'M',0,
    'O',0,
/* Index 0x36: Serial Number */
    0x0A,                                  // bLength
    USB_STRING_DESCRIPTOR_TYPE,            // bDescriptorType
    'D',0,
    'E',0,
    'M',0,
    'O',0,
/* Index 0x40: Interface 0, Alternate Setting 0 */
    0x08,                                  // bLength
    USB_STRING_DESCRIPTOR_TYPE,            // bDescriptorType
    'H',0,
    'I',0,
    'D',0,                                 // sadfgadsf
};
