#include <LPC214x.H>

#define Fosc         12000000
#define Fpclk        60000000

unsigned int   txin;           // Next In Index
unsigned int   txout;          // Next Out Index
unsigned char *txbuf;          // pointer to Tx buffer


__irq void U1_Isr(void)
{
  char i = 16;

    if ((U1IIR & 0x0F) == 2)   // THRE Interrupt ?
    {
        while (i && txout)
        {
            U1THR = txbuf[txin++];
            txout --;
            i --;
        }
    }
    VICVectAddr = 0;           // Acknowledge Interrupt
}

void UART1_Send(unsigned char *buf, unsigned int len)
{
  char i = 16;

    if (txout == 0)            // previous message send ?
    {
        txbuf = buf;           // copy buffer pointer
        txout = len;
        txin  = 0;
        while (i && txout)
        {
            U1THR = txbuf[txin++];
            txout --;
            i --;
        }
    }
}

void UART1_Init(unsigned int baudrate)
{
  volatile char dummy;
  unsigned int  brd = (Fpclk / (baudrate << 4));
	
    txin  = 0;
    txout = 0;
    PINSEL0 |= 0x00050000;     // Select U1 RXD/TXD

//    U1IER = 0;                 // Disable UART1 Interrupts
    U1FCR = 7;                 // Enable and clear FIFO's	
    U1LCR = 0x87;              // Set DLAB and set word format to 8-N-2
    U1DLL = (brd & 0xFF);      // Set baud rate dividers
    U1DLM = (brd >> 8);        //
    U1LCR = 7;                                 // Disable Divisor latch bit

    VICVectAddr3  = (unsigned int) &U1_Isr;
    VICVectCntl3  = 0x27;                      // Channel2 on Source #7 ... enabled
    VICIntEnable |= 0x00000080;                // Source #7 is UART1

    dummy = U1IIR;                             // Read IrqID to get interrupts started
    U1IER = 2;                                 // Enable UART1 THRE Interrupt
}









