#include <LPC214x.H>               // LPC214x definitions

char f_10ms  = 0;
char f_200ms = 0;


__irq void T1_Isr(void)            // Timer 1 ISR every 10 msec
{
  static unsigned char cnt = 0;

    f_10ms = 1;                    // toggles every 10 mseconds

    if (++cnt > 20)
    {
        cnt = 0;
        f_200ms = 1;               // toggles every 100 mseconds
    }
    T1IR = 0x01;                   // reset interrupt flag
    VICVectAddr = 0;               // reset VIC
}
  
void T1_Init(void)
{
    VICVectAddr2  = (unsigned int) &T1_Isr;
    VICVectCntl2  = 0x25;          // Channel2 on Source#5 ... enabled
    VICIntEnable |= 0x20;          // Channel#5 is the Timer 1

    T1MR0 = 600000;                // = 10 msec / 16,67 nsec
    T1MCR = 3;                     // Interrupt on Match0, reset timer on match
                                   // Pclk = 60 MHz
                                   // timer count = 16,67 nsec
    T1TC  = 0;                     // reset Timer counter
    T1TCR = 1;                     // enable Timer
}
