#include <LPC214x.H>

#include "uart1.h"
//#include "dmx.h"

unsigned char DMX_buf[513];


void DMX_SendPacket(void)
{
    T0TC  = 0;                                 // reset Timer counter
    T0IR  = 0x01;                              // reset interrupt flag
    T0MR0 = 92;                                // set match to 92 us
    U1LCR = 0x47;                              // 'break'
    T0TCR = 1;                                 // start timer 0
    while ((T0IR & 0x01) == 0);                // wait for timer match

    T0TC  = 0;                                 // reset Timer counter
    T0IR  = 0x01;                              // reset interrupt flag
    T0MR0 = 12;                                // set match to 12 us
    U1LCR = 7;                                 // 'mark'
    T0TCR = 1;                                 // start timer 0
    while ((T0IR & 0x01) == 0);                // wait for timer match

    UART1_Send(DMX_buf,513);                   // send data packet to slaves
}

void DMX_Init(void)
{
  int i;

    for (i = 0; i < 513; i++)
        DMX_buf[i] = 0;

	IODIR0 |= 0x00000080;                      // P0.7 = DS75176 enable
	IOSET0 |= 0x00000080;                      // Tx enable high active

    UART1_Init(250000);

    T0PR  = 60;                                // prescaler 60, timer runs at 60 MHz / 60 = 1 MHz
    T0MCR = 7;                                 // Interrupt on MR0, reset and stop the timer
}
