#include <LPC2103.H>

#define Fosc         12000000
#define Fpclk        60000000

unsigned int  rxin;                        // buffer index
unsigned char DMX_buf[513];


__irq void U1_Isr(void)
{
  static int  iid;

    while (((iid = U1IIR) & 1) == 0)
    {
        if ((iid & 0x0E) == 6)             // Receive Line Status
        {
            U1LSR;                         // read LSR to clear the interrupt
            U1RBR;
            rxin = 0;
        }        
        else                               // Receive Data Available
        {
            do
            {
                DMX_buf[rxin] = U1RBR;
                if (rxin < 513)
                    rxin ++;
            } while (U1LSR & 1);           // receive data ready
        }
    }
    VICVectAddr = 0;                       // Acknowledge Interrupt
}

void UART1_Init(unsigned int baudrate)
{
  volatile char dummy;
  unsigned int  brd = (Fpclk / (baudrate << 4));
//  int i;

//    for (i = 0; i < 512; i++)
//        DMX_buf[i] = 'a';

	IODIR |= 0x00000080;                      // P0.7 = DS75176 enable
	IOCLR |= 0x00000080;                      // Rx enable, low active

    rxin  = 0;
    PINSEL0 |= 0x00050000;         // Select U1 RXD/TXD

    U1FCR = 0x87;                  // Enable and clear FIFO's, trigger level 2	
    U1LCR = 0x87;                  // Set DLAB and set word format to 8-N-2
    U1DLL = (brd & 0xFF);          // Set baud rate dividers
    U1DLM = (brd >> 8);            //
    U1LCR = 7;                     // Disable Divisor latch bit

    VICVectAddr0  = (unsigned int) &U1_Isr;
    VICVectCntl0  = 0x27;                      // Channel0 on Source #7 ... enabled
    VICIntEnable |= 0x00000080;                // Source #7 is UART1

    dummy = U1IIR;                 // Read IrqID to get interrupts started
    U1IER = 5;                     // Enable UART1 RBR and Rx line status Interrupt
}









