#include <LPC214x.h>                   // LPC21xx definitions

#include "main.h"

const char ascii[] = "0123456789ABCDEF";


void UART0_Init(unsigned int baudrate)
{
  unsigned int brd = (Fpclk / (baudrate << 4));
	
    PINSEL0 |= 0x00000005;             // Select U0 RXD/TXD

    U0FCR = 7;                         // Enable and clear FIFO's	
    U0LCR = 0x83;                      // Set DLAB and set word format to 8-N-1
    U0DLL = (brd & 0xFF);              // Set baud rate dividers
    U0DLM = (brd >> 8);                //
    U0LCR = 3;                         // Disable Divisor latch bit
}

static void ua_outchar(char c)
{
    U0THR = c;
    while(!(U0LSR & 0x40));
}

void PrintByte(unsigned char b)
{
    ua_outchar(ascii[b >> 4]);
    ua_outchar(ascii[b & 0x0f]);
}

void PrintString(const char *s)
{
    while (*s)
    {
        if (*s == '\n')
            ua_outchar('\r');          // output a '\r' first
        ua_outchar(*s);
        s++;
    }
}
