/*****************************************************************************
 * channel_map.c 
 *
 * Project: LPC17xx Capacitive Touch Sensing demo program
 *
 * Description:
 *   Implements the tables for the mapping between ADC channels and Key Pad
 *
 *----------------------------------------------------------------------------
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *                  (C) Copyright 2011 NXP Semiconductors
 *****************************************************************************/
/* includes */
#include "includes.h"


/*****************************************************************************
 * Note: users do not need to modify these tables, configuration is done
 * within the config.h file
 ****************************************************************************/

/*****************************************************************************
 * This table holds the mapping between the Keypad numbering and the        
 * ADC channel number (CH0 to CH7)
 ****************************************************************************/
const ChannelIdType Kpad2ChMap[NUM_KPAD]=
{
    KBD1_ASSIGNED_CHANNEL,
    KBD2_ASSIGNED_CHANNEL,
    KBD3_ASSIGNED_CHANNEL,
    KBD4_ASSIGNED_CHANNEL,
    KBD5_ASSIGNED_CHANNEL,
    KBD6_ASSIGNED_CHANNEL,
    KBD7_ASSIGNED_CHANNEL,
    KBD8_ASSIGNED_CHANNEL    
};

/*****************************************************************************
 * This table holds the mapping between the ADC Channel number (CH0 to CH7)
 * and the Keypad number (KBD1 to KBD8)
 ****************************************************************************/
const KeypadIdType Ch2KpadMap[NUM_CHANNELS]=
{
    CH0_ASSIGNED_KBD,
    CH1_ASSIGNED_KBD,
    CH2_ASSIGNED_KBD,
    CH3_ASSIGNED_KBD,
    CH4_ASSIGNED_KBD,
    CH5_ASSIGNED_KBD,
    CH6_ASSIGNED_KBD,
    CH7_ASSIGNED_KBD
};


/* end of file */
