/******************************************************************************/
/* BLINKY.C: LED Flasher                                                      */
/******************************************************************************/
/* This file is part of the uVision/ARM development tools.                    */
/* Copyright (c) 2008 Keil Software. All rights reserved.                     */
/* This software may only be used under the terms of a valid, current,        */
/* end user licence from KEIL for a compatible version of KEIL software       */
/* development tools. Nothing else gives you the right to use this software.  */
/******************************************************************************/
/*																			  */
/*	The Blinky example was modified to test CRP3 Re-Invoke function																		  */
/*																			  */
                  
#include "LPC17xx.H"                    /* LPC17xx definitions                */

#define LED_NUM     8                   /* Number of user LEDs                */


/* CRP3 test related section                                                  */
#define TIMEOUT     10000				/* Timeout   (0 to disable)           */
#define IAP_LOCATION 0x1FFF1FF1
unsigned int command[5];
unsigned int result[2];
typedef void (*IAP)(unsigned int [],unsigned int[]);
IAP iap_entry = (IAP) IAP_LOCATION;
/* end CRP3 test related section                                              */


const unsigned long led_mask[] = { 1<<28, 1<<29, 1UL<<31, 1<<2, 1<<3, 1<<4, 1<<5, 1<<6 };
volatile unsigned long SysTickCnt;      /* SysTick Counter                    */

void SysTick_Handler (void) {           /* SysTick Interrupt Handler (1ms)    */
  SysTickCnt++;
}

void Delay (unsigned long tick) {       /* Delay Function                     */
  unsigned long systickcnt;

  systickcnt = SysTickCnt;
  while ((SysTickCnt - systickcnt) < tick);
}

int main (void) {                       /* Main Program                       */
  int num = -1; 
  int dir =  1;
 
  GPIO_TypeDef *gpio;

  SystemInit();

  SysTick_Config(SystemFrequency/1000 - 1); /* Generate interrupt each 1 ms   */

  GPIO1->FIODIR = 0xB0000000;           /* LEDs on PORT1 defined as Output    */
  GPIO2->FIODIR = 0x0000007C;           /* LEDs on PORT2 defined as Output    */

  for (;;) {                            /* led blinking fast  */
    /* Calculate 'num': 0,1,...,LED_NUM-1,LED_NUM-1,...,1,0,0,...             */
    num += dir;
    if (num == LED_NUM) { dir = -1; num =  LED_NUM-1; } 
    else if   (num < 0) { dir =  1; num =  0;         }

    if (num < 3) gpio = GPIO1;
    else         gpio = GPIO2;
    gpio->FIOPIN |=  led_mask[num];
    Delay(200);             			           
    gpio->FIOPIN &= ~led_mask[num];
    Delay(100);   
	/* detect if user pressed Re-Invoke button  */                      
	if ((GPIO1->FIOPIN & 0x00100000) == 0)
	  break;
	/* if timeout is enabled, check timeout     */
	if (SysTickCnt > TIMEOUT && TIMEOUT)
	  break;
  }

  /* Re-Invoke ISP  */
  __disable_irq();
  command[0] = 57;		// Reinvoke ISP	command
  iap_entry (command, result);

  /* code should not get here... */
  while(1);
}
