/***********************************************************************
* $Id:: lpc17xx_clock_power.h 1038 2008-08-07 02:13:47Z stefanovicz    $
*
* Project: LPC17xx clocking and power control definitions
*
* Description:
*     This file contains the structure definitions and manifest
*     constants for the LPC17xx chip family component:
*         Clocking and power control
*
***********************************************************************
* Software that is described herein is for illustrative purposes only  
* which provides customers with programming information regarding the  
* products. This software is supplied "AS IS" without any warranties.  
* NXP Semiconductors assumes no responsibility or liability for the 
* use of the software, conveys no license or title under any patent, 
* copyright, or mask work right to the product. NXP Semiconductors 
* reserves the right to make changes in the software without 
* notification. NXP Semiconductors also make no representation or 
* warranty that such application will be suitable for the specified 
* use without further testing or modification. 
**********************************************************************/

#ifndef LPC17XX_CLOCK_POWER_H
#define LPC17XX_CLOCK_POWER_H

#include "type.h"
#include "lpc17xx.h"

#ifdef __cplusplus
extern "C" {
#endif


#define POWER_BASE      0x400FC0C0  /* Power control register base  */

/**********************************************************************
* PLL definitions
**********************************************************************/
/* PLL register structure */ 
typedef struct {
    volatile UNS_32 con;        /* PLL control register             */
    volatile UNS_32 cfg;        /* PLL configuration register       */
    volatile UNS_32 stat;       /* PLL status register              */
    volatile UNS_32 feed;       /* PLL feed register                */
} PLL_REGS_T;

/**********************************************************************
* Power definitions
**********************************************************************/
/* Power register structure */ 
typedef struct {
    volatile UNS_32 con;        /* Power control register           */
    volatile UNS_32 conp;       /* Power ctrl for peripherals reg   */
} POWER_REGS_T;

/**********************************************************************
* Power control register definitions
**********************************************************************/

/**********************************************************************
* Power control for peripheral register definitions
**********************************************************************/
#define PCTIM0      (1<<1)
#define PCTIM1      (1<<2)
#define PCUART0     (1<<3)
#define PCUART1     (1<<4)
#define PCWM1       (1<<6)
#define PCI2C0      (1<<7)
#define PCSPI       (1<<8)
#define PCRTC       (1<<9)
#define PCSSP1      (1<<10)
#define PCAD        (1<<12)
#define PCCAN1      (1<<13)
#define PCCAN2      (1<<14)
#define PCGPIO      (1<<15)
#define PCRIT       (1<<16)
#define PCMCPWM     (1<<17)
#define PCQEI       (1<<18)
#define PCI2C1      (1<<19)
#define PCSSP0      (1<<21)
#define PCTIM2      (1<<22)
#define PCTIM3      (1<<23)
#define PCUART2     (1<<24)
#define PCUART3     (1<<25)
#define PCI2C2      (1<<26)
#define PCI2S       (1<<27)
#define PCGPDMA     (1<<29)
#define PCENET      (1<<30)
#define PCUSB       (1<<31)

/**********************************************************************
* Clock definitions
**********************************************************************/
/* Clock register structure */ 
typedef struct {
    volatile UNS_32 ccfg;       /* CPU clock configuration register */
    volatile UNS_32 ucfg;       /* USB clock configuration register */
    volatile UNS_32 srcsel;     /* Clock source select register     */
    volatile UNS_32 reserved1[37];
    volatile UNS_32 irctrim;    /* IRC trim register                */
    volatile UNS_32 psel0;      /* Peripheral clock selection reg0  */
    volatile UNS_32 psel1;      /* Peripheral clock selection reg1  */
} CLOCK_REGS_T;

/* Macros pointing to PLL, Power, and Clock  registers */
#define PLL0    ((PLL_REGS_T *)(PLL0_BASE))
#define PLL1    ((PLL_REGS_T *)(PLL1_BASE))
#define POWER   ((POWER_REGS_T *)(POWER_BASE))
#define CLOCK   ((CLOCK_REGS_T *)(CLOCK_BASE))


#ifdef __cplusplus
}
#endif

#endif /* LPC17XX_CLOCK_POWER_H */ 
