#ifndef __IEC60335_ErLo_
#define __IEC60335_ErLo_

//#include "IEC60335.h"

/*! \brief The definition of the error codes */
typedef enum tag_ErrorCodes
{
	IEC60335_noError						= 0, /*! No Error occured.*/
	IEC60335_criticalDataCheckFailed		= 1, /*! Check of critical Data detected an error.*/
	IEC60335_InterruptFailed				= 2, /*! Interrupt check detected an error. */
} type_ErrorCode;

/*! \brief Initialises the IEC60335 error logging mechanism. */
void IEC60335_initErrorLog(UINT32 *pLogBuffer, UINT32 length);

/*! \brief Inserts an error code into the log. */
type_testResult IEC60335_notifyErrorCode(type_ErrorCode EC);
/*! \brief Returns the last error code */
type_ErrorCode IEC60335_getLastErrorCode(void);

#endif
