/*****************************************************************************
 * config.h 
 *
 * Project: LPC17xx Capacitive Touch Sensing demo program
 *
 * Description:
 *   User configuration for the demo project
 *
 *----------------------------------------------------------------------------
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *                  (C) Copyright 2011 NXP Semiconductors
 *****************************************************************************/
#ifndef __CTOUCH_CONFIG_H__
#define __CTOUCH_CONFIG_H__


/*****************************************************************************
 * Type definition for the keypad numbering 
 * DO NOT MODIFY
 ****************************************************************************/
/* defined kpads */
typedef enum {
        KBD1 = 0,
        KBD2,
        KBD3,
        KBD4,
        KBD5,
        KBD6,
        KBD7,
        KBD8,
        NUM_KPAD,
        UNUSED_KPAD
} KeypadIdType;


/*****************************************************************************
 * User configuration part, edit to specify:
 *
 *  - which keypads are used, by setting the USE_KBDn value to 1
 *      ex:   #define USE_KBD2 1
 *
 *  - for the used keypads, the ADC channel being connected to the keypad 
 *      ex:   #define KBD2_ASSIGNED_CHANNEL   (CH7)
 *            #define CH7_ASSIGNED_KBD        (KBD2)
 * 
 * the user has to take care that the configuration is consistent, i.e. that
 * an ADC channel is linked to only one keypad
 ****************************************************************************/


/*****************************************************************************
 * Keypad #1 
 ****************************************************************************/
#define USE_KBD1 0
#if(USE_KBD1 == 1)
    #define KBD1_ASSIGNED_CHANNEL   (x)
    #define CHn_ASSIGNED_KBD        (y)
#endif

/*****************************************************************************
 * Keypad #2 
 ****************************************************************************/
#define USE_KBD2 0
#if(USE_KBD2 == 1)
    #define KBD2_ASSIGNED_CHANNEL   (CH7)
    #define CH7_ASSIGNED_KBD        (KBD2)
#endif

/*****************************************************************************
 * Keypad #3 
 ****************************************************************************/
#define USE_KBD3 0
#if(USE_KBD3 == 1)
    #define KBD3_ASSIGNED_CHANNEL   (CH6)
    #define CH6_ASSIGNED_KBD        (KBD3)
#endif

/*****************************************************************************
 * Keypad #4 
 ****************************************************************************/
#define USE_KBD4 0
#if(USE_KBD4 == 1)
    #define KBD4_ASSIGNED_CHANNEL   (x)
    #define CHn_ASSIGNED_KBD        (y)
#endif

/*****************************************************************************
 * Keypad #5 
 ****************************************************************************/
#define USE_KBD5 1
#if(USE_KBD5 == 1)
    #define KBD5_ASSIGNED_CHANNEL   (CH2)
    #define CH2_ASSIGNED_KBD        (KBD5)
#endif

/*****************************************************************************
 * Keypad #6 
 ****************************************************************************/
#define USE_KBD6 1
#if(USE_KBD6 == 1)
    #define KBD6_ASSIGNED_CHANNEL   (CH3)
    #define CH3_ASSIGNED_KBD        (KBD6)
#endif

/*****************************************************************************
 * Keypad #7 
 ****************************************************************************/
#define USE_KBD7 0
#if(USE_KBD7 == 1)
    #define KBD7_ASSIGNED_CHANNEL   (x)
    #define CHn_ASSIGNED_KBD        (y)
#endif

/*****************************************************************************
 * Keypad #8 
 ****************************************************************************/
#define USE_KBD8 0
#if(USE_KBD8 == 1)
    #define KBD8_ASSIGNED_CHANNEL   (CH4)
    #define CH4_ASSIGNED_KBD        (KBD8)
#endif
                                            

/*****************************************************************************
 * End of User configuration part, DO NOT EDIT BELOW THIS LINE
 ****************************************************************************/




/*****************************************************************************
 * Specify default mappings for unused channels / keypads
 ****************************************************************************/

/* filling up unused kpads */
#ifndef KBD1_ASSIGNED_CHANNEL
    #define KBD1_ASSIGNED_CHANNEL (UNUSED_CHANNEL)
#endif

#ifndef KBD2_ASSIGNED_CHANNEL
    #define KBD2_ASSIGNED_CHANNEL (UNUSED_CHANNEL)
#endif

#ifndef KBD3_ASSIGNED_CHANNEL
    #define KBD3_ASSIGNED_CHANNEL (UNUSED_CHANNEL)
#endif

#ifndef KBD4_ASSIGNED_CHANNEL
    #define KBD4_ASSIGNED_CHANNEL (UNUSED_CHANNEL)
#endif

#ifndef KBD5_ASSIGNED_CHANNEL
    #define KBD5_ASSIGNED_CHANNEL (UNUSED_CHANNEL)
#endif

#ifndef KBD6_ASSIGNED_CHANNEL
    #define KBD6_ASSIGNED_CHANNEL (UNUSED_CHANNEL)
#endif

#ifndef KBD7_ASSIGNED_CHANNEL
    #define KBD7_ASSIGNED_CHANNEL (UNUSED_CHANNEL)
#endif

#ifndef KBD8_ASSIGNED_CHANNEL
    #define KBD8_ASSIGNED_CHANNEL (UNUSED_CHANNEL)
#endif


/* fill up unused channels   */
#ifndef CH0_ASSIGNED_KBD
    #define CH0_ASSIGNED_KBD (UNUSED_KPAD)
#endif

#ifndef CH1_ASSIGNED_KBD
    #define CH1_ASSIGNED_KBD (UNUSED_KPAD)
#endif

#ifndef CH2_ASSIGNED_KBD
    #define CH2_ASSIGNED_KBD (UNUSED_KPAD)
#endif

#ifndef CH3_ASSIGNED_KBD
    #define CH3_ASSIGNED_KBD (UNUSED_KPAD)
#endif

#ifndef CH4_ASSIGNED_KBD
    #define CH4_ASSIGNED_KBD (UNUSED_KPAD)
#endif

#ifndef CH5_ASSIGNED_KBD
    #define CH5_ASSIGNED_KBD (UNUSED_KPAD)
#endif

#ifndef CH6_ASSIGNED_KBD
    #define CH6_ASSIGNED_KBD (UNUSED_KPAD)
#endif

#ifndef CH7_ASSIGNED_KBD
    #define CH7_ASSIGNED_KBD (UNUSED_KPAD)
#endif



#endif   /* __CTOUCH_CONFIG_H__ */


