/******************************************************************************
 *   cortexm3_macro.h:  Header file for NXP LPC17xx Family 
 *   Microprocessors
 *
 *   Copyright(C) 2008, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2008.08.21  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/
#ifndef __CORTEXM3_MACRO_H 
#define __CORTEXM3_MACRO_H

#include "type.h"

/* Exported functions ------------------------------------------------------- */
void __WFI(void);
void __WFE(void);
void __SEV(void);
void __ISB(void);
void __DSB(void);
void __DMB(void);
void __SVC(void);
DWORD __MRS_CONTROL(void);
void __MSR_CONTROL(DWORD Control);
DWORD __MRS_PSP(void);
void __MSR_PSP(DWORD TopOfProcessStack);
DWORD __MRS_MSP(void);
void __MSR_MSP(DWORD TopOfMainStack);
void __SETPRIMASK(void);
void __RESETPRIMASK(void);
void __SETFAULTMASK(void);
void __RESETFAULTMASK(void);
void __BASEPRICONFIG(DWORD NewPriority);
DWORD __GetBASEPRI(void);
WORD __REV_HalfWord(WORD Data);
DWORD __REV_Word(DWORD Data);

#endif /* end __CORTEXM3_MACRO_H */

/******************************************************************************
**                            End Of File
******************************************************************************/
