/********************************************************************
 * Project:    Cortex-M3 Template
 * File:       startup.c
 *
 * System:     Cortex M3
 * Compiler:   GNU GCC 
 *
 * Date:       2008-05-12
 * Author:     Application@Hitex.de
 *
 * Rights:     Hitex Development Tools GmbH
 *             Greschbachstr. 12
 *             D-76229 Karlsruhe
 ********************************************************************
 * Description:
 * startup.c
 * Startup code for applications based on Cortex M3
 ********************************************************************
 * History:
 *
 * Initial revision : 2009-05-12
 ********************************************************************
 * This is a preliminary version.
 *
 * WARRANTY:  HITEX warrants that the media on which the SOFTWARE is
 * furnished is free from defects in materials and workmanship under
 * normal use and service for a period of ninety (90) days. HITEX entire
 * liability and your exclusive remedy shall be the replacement of the
 * SOFTWARE if the media is defective. This Warranty is void if failure
 * of the media resulted from unauthorized modification, accident, abuse,
 * or misapplication.
 *
 * DISCLAIMER:  OTHER THAN THE ABOVE WARRANTY, THE SOFTWARE IS FURNISHED
 * "AS IS" WITHOUT WARRANTY OF ANY KIND. HITEX DISCLAIMS ALL OTHER WARRANTIES,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * NEITHER HITEX NOR ITS AFFILIATES SHALL BE LIABLE FOR ANY DAMAGES ARISING
 * OUT OF THE USE OF OR INABILITY TO USE THE SOFTWARE, INCLUDING DAMAGES FOR
 * LOSS OF PROFITS, BUSINESS INTERRUPTION, OR ANY SPECIAL, INCIDENTAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES EVEN IF HITEX HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGES.
 ********************************************************************/

#include "interrupt.h"
#include "LPC17xx.h"


#include "main.h"
#include "IEC60335.h"

/*******************************************************************************
* Prototypes
*******************************************************************************/

void Reset(void);
//void Reset(void) __attribute__((interrupt));
void NMIException(void);
//static void NMIExcep(void) __attribute__((interrupt));
void HardFaultException(void);
//static void HardFaultExcep(void) __attribute__((interrupt));
void DefaultHandler(void)__attribute__((noreturn));
//static void DefaultHandler(void) __attribute__((interrupt, noreturn));

/*******************************************************************************
* main Prototype
*******************************************************************************/
extern int main(void);
extern void TimingDelay_Decrement(void);

/*******************************************************************************
* Stack Definition
*******************************************************************************/

extern	unsigned long 	_stacktop;


/*******************************************************************************
* Interrupt Vector Table
*******************************************************************************/
typedef void (* const IntFctPointer)(void);

IntFctPointer interrupts[] __attribute__ ((section(".vectors"))) =
{
   (IntFctPointer)&_stacktop,             // The initial stack pointer
   Reset,                                 // 1 reset handler
   NMIException,                          // 2 NMI handler
   HardFaultException,                    // 3 hard fault handler
   MemManageException,                    // 4 MPU fault handler
   BusFaultException,                     // 5 bus fault handler
   UsageFaultException,                   // 6 usage fault handler
   (IntFctPointer)0xEFFF7876,                            // checksum
   0,                                     // Reserved
   0,                                     // Reserved
   0,                                     // Reserved
   SVCHandler,                            // 11 SVCall exception handler
   DebugMonitor,                          // 12 Debug monitor handler
   0,                                     // Reserved
   PendSVC,                               // 14 The PendSVC handler
   SysTickHandler,                        // 15 SysTick handler
   WDINT_Handler,                         // 16 WDINT handler
   TIMER0_Handler,                        // 17 Timer 0  handler
   TIMER1_Handler,                     	  // 18 Timer 1 handler
   TIMER2_Handler,                        // 19 Timer 2 handler
   TIMER3_Handler,                        // 20 Timer 3 handler
   UART0_Handler,                         // 21 UART0_Handler
   UART1_Handler,                         // 22 UART1_Handler
   UART2_Handler,                         // 23 UART2_Handler
   UART3_Handler,                         // 24 UART3_Handler
   PWM1_Handler,                          // 25 PWM handler
   I2C0_Handler,                          // 26 I2C 0 handler
   I2C1_Handler,                          // 27 I2C 1  handler
   I2C2_Handler,                          // 28 I2C 2 handler
   SPI_Handler,                           // 29 SPI handler
   SSP0_Handler,                          // 30 SSP 0 handler
   SSP1_Handler,                          // 31 SSP1 handler
   PLL0_Handler,                		  // 32 PLL0  (main PLL) handler
   RTC_Handler,                			  // 33 RTC handler
   EXTI0_Handler,                         // 34 external interrupt 0 handler
   EXTI1_Handler,              			  // 35 external interrupt 1 handler
   EXTI2_Handler,             			  // 36 external interrupt 2 handler
   EXTI3_Handler,                    	  // 37 external interrupt 3 handler
   ADC_Handler,                    		  // 38 ADC handler
   BOD_Handler,                    		  // 39 Brown out detection interrupt handler
   USB_Handler,                   		  // 40 USB handler
   CAN_Handler,                    		  // 41 CAN interrupt handler
   GP_DMA_Handler,               		  // 42 DMA interrupts handler
   I2S_Handler,                    		  // 43 I2S interrupt handler
   ETHERNET_Handler,   	                  // 44 Ethernet interrupt handler
   RITINT_Handler,                        // 45 repetitive interrupt timer handler
   MC_PWM_Handler,                        // 46 Notor control PWM handler
   QENC_Handler,                    	  // 47 quadrature encoder handler
   PLL1_Handler,                          //	48 USB PLL handler
   USB_ACT_Handler,                       // 49 USB activity handler
   CAN_ACT_Handler,                       // 50 Can activity handler
   DefaultHandler                         // 59 all undefined handler
};

/*******************************************************************************
* reference to linker symbols
*******************************************************************************/

extern unsigned long _etext;
extern unsigned long _data;
extern unsigned long _edata;
extern unsigned long _bss;
extern unsigned long _ebss;

/*******************************************************************************
* Function Name  : Reset
* Description    : Initial Entry after POR or SW-Reset, prepares bss section
*                  and initial values, branch to main
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/

FlashSign_t testsoft, testhard;
void Reset(void)
{
    unsigned long *Src, *Dest;
	type_testResult Result;
	   
	StartSoftSignatureGen(0,SIZE512K - 16,&testsoft);
	StartHardSignatureGen(0,SIZE512K - 16,&testhard);
	Result = IEC60335_testSignatures(&testsoft, &testhard);

	if(Result != IEC60335_testPassed)
		while(1); // Error in the CRC machine of the Flash Memorycontroller 

	Result = IEC60335_FLASHtest_POST (SIZE512K - 16);

	if(Result != IEC60335_testPassed)
		while(1); // Flash content is not consitent 
	
	Result = IEC60335_RAMtest_POST();

	if(Result != IEC60335_testPassed)
		while(1); // RAM has failures 
				
	Result = IEC60335_CPUregTest_POST();

	if(Result != IEC60335_testPassed)
		while(1); // Regiters have failures 
				
   // Copy the data segment initializers from flash to SRAM.
   Src = &_etext;
   for(Dest = &_data; Dest < &_edata; )
   {
     *Dest++ = *Src++;
   }

   // Zero fill the bss segment.
   for(Dest = &_bss; Dest < &_ebss; )
   {
     *Dest++ = 0;
   }

	Result = IEC60335_B_PCTest_POST();		//for PC test, the C environment must be loaded!
	
	if(Result != IEC60335_testPassed)
		while(1); // RAM has failures 

   // Call main.
   main();
}


/*******************************************************************************
* Function Name  : NMIException
* Description    : This function handles NMI exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void NMIException(void)
{
}

/*******************************************************************************
* Function Name  : HardFaultException
* Description    : This function handles Hard Fault exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void HardFaultException(void)
{
}

/*******************************************************************************
* Function Name  : MemManageException
* Description    : This function handles Memory Manage exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void MemManageException(void)
{
}

/*******************************************************************************
* Function Name  : BusFaultException
* Description    : This function handles Bus Fault exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void BusFaultException(void)
{
}

/*******************************************************************************
* Function Name  : UsageFaultException
* Description    : This function handles Usage Fault exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void UsageFaultException(void)
{
}

/*******************************************************************************
* Function Name  : DebugMonitor
* Description    : This function handles Debug Monitor exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void DebugMonitor(void)
{
}

/*******************************************************************************
* Function Name  : SVCHandler
* Description    : This function handles SVCall exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SVCHandler(void)
{
}

/*******************************************************************************
* Function Name  : PendSVC
* Description    : This function handles PendSVC exception.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void PendSVC(void)
{
}

/*******************************************************************************
* Function Name  : SysTickHandler
* Description    : This function handles SysTick Handler.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SysTickHandler(void)
{
}

/*******************************************************************************
* Function Name  : WDINT_Handler
* Description    : This function handles watchdog interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void WDINT_Handler(void)
{
}

/*******************************************************************************
* Function Name  : Timer0_Handler
* Description    : This function handles the timer0 interrupt requests.
*		        Match 0 - 1, capture 0 - 1		
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIMER0_Handler(void)
{
	TIM0->IR = 0x00000001;
	IEC60335_Clocktest_TimerIntHandler();
}

/*******************************************************************************
* Function Name  : Timer1_Handler
* Description    : This function handles the timer0 interrupt requests.
*		        Match 0 - 1, capture 0 - 1		
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIMER1_Handler(void)
{
	TIM1->IR = 0x00000001;
	IEC60335_InterruptOcurred(&IQtest);
}

/*******************************************************************************
* Function Name  : Timer2_Handler
* Description    : This function handles the timer0 interrupt requests.
*		        Match 0 - 1, capture 0 - 1		
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIMER2_Handler(void)
{
	TIM2->IR = 0x00000001;
}

/*******************************************************************************
* Function Name  : Timer3_Handler
* Description    : This function handles the timer0 interrupt requests.
*		        Match 0 - 1, capture 0 - 1		
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void TIMER3_Handler(void)
{
	TIM3->IR = 0x00000001;
}

/*******************************************************************************
* Function Name  : UART0_Handler
* Description    : This function handles UART 0 interrupt requests.
*			RX line Status
*			Transmit holding
*			Receive data available
*			character timeout
*			modem control change
*			end of autobaud
*			auto-baud-time	
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void UART0_Handler(void)
{
}

/*******************************************************************************
* Function Name  : UART1_Handler
* Description    : This function handles UART 0 interrupt requests.
*			RX line Status
*			Transmit holding
*			Receive data available
*			character timeout
*			modem control change
*			end of autobaud
*			auto-baud-time	
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void UART1_Handler(void)
{
}

/*******************************************************************************
* Function Name  : UART2_Handler
* Description    : This function handles UART 0 interrupt requests.
*			RX line Status
*			Transmit holding
*			Receive data available
*			character timeout
*			modem control change
*			end of autobaud
*			auto-baud-time	
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void UART2_Handler(void)
{
}

/*******************************************************************************
* Function Name  : UART3_Handler
* Description    : This function handles UART 0 interrupt requests.
*			RX line Status
*			Transmit holding
*			Receive data available
*			character timeout
*			modem control change
*			end of autobaud
*			auto-baud-time	
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void UART3_Handler(void)
{
}

/*******************************************************************************
* Function Name  :PWM1_Handler
* Description    : This function handles PWM interrupts
*			match 0 - 6, capture 0,1
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void PWM1_Handler(void)
{
}

/*******************************************************************************
* Function Name  : I2C0_Handler
* Description    : This function handles I2C interrupt request.
*			si state change
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void I2C0_Handler(void)
{
}

/*******************************************************************************
* Function Name  : I2C1_Handler
* Description    : This function handles I2C interrupt request.
*			si state change
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void I2C1_Handler(void)
{
}

/*******************************************************************************
* Function Name  : I2C2_Handler
* Description    : This function handles I2C interrupt request.
*			si state change
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void I2C2_Handler(void)
{
}

/*******************************************************************************
* Function Name  : SPI_Handler
* Description    : This function handles SPI interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SPI_Handler(void)
{
}

/*******************************************************************************
* Function Name  : SSP0_Handler
* Description    : This function handles SSP0 interrupt request.
*			TxFifo
*			Rx Fifo
*			Rx timeout
*			Rx overrun	
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SSP0_Handler(void)
{
}

/*******************************************************************************
* Function Name  : SSP1_Handler
* Description    : This function handles SSP0 interrupt request.
*			TxFifo
*			Rx Fifo
*			Rx timeout
*			Rx overrun	
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SSP1_Handler(void)
{
}

/*******************************************************************************
* Function Name  : PLL0 Handler
* Description    : This function handles main PLL interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void PLL0_Handler(void)
{
}

/*******************************************************************************
* Function Name  : RTC_Handler
* Description    : This function handles RTC interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void RTC_Handler(void)
{
	static BOOL skipFirst = TRUE;
	RTC->ILR = 0x00000001;

	if(skipFirst == TRUE)
		skipFirst = FALSE;
	else
		IEC60335_Clocktest_RTCHandler();

	{
		BOOL Result = FALSE;

		Result = IEC60335_InterruptCheck(&IQtest);
	}
}
/*******************************************************************************
* Function Name  : EXTI0_Handler
* Description    : This function handles external interrupt requests
*                  requests.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI0_Handler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI1_Handler
* Description    : This function handles external interrupt requests
*                  requests.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI1_Handler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI2_Handler
* Description    : This function handles external interrupt requests
*                  requests.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI2_Handler(void)
{
}

/*******************************************************************************
* Function Name  : EXTI3_Handler
* Description    : This function handles external interrupt requests
*                  requests.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI3_Handler(void)
{
}

/*******************************************************************************
* Function Name  : ADC_Handler
* Description    : This function handles ADC global interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void ADC_Handler(void)
{
}

/*******************************************************************************
* Function Name  : BOD_Handler
* Description    : This function handles BOD (brown out detec.) interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void BOD_Handler(void)
{
}

/*******************************************************************************
* Function Name  : USB_Handler
* Description    : This function handles USB interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USB_Handler(void)
{
}

/*******************************************************************************
* Function Name  : CAN_Handler
* Description    : This function handles CAN  interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void CAN_Handler(void)
{
}

/*******************************************************************************
* Function Name  : GP_DMA_Handler
* Description    : This function handles DMA interrupt request.
*			int status channel 0 and 1
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void GP_DMA_Handler(void)
{
}

/*******************************************************************************
* Function Name  : I2S_Handler
* Description    : This function handles I2S interrupt
*                  request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void I2S_Handler(void)
{
}

/*******************************************************************************
* Function Name  : ETHERNET_Handler
* Description    : This function handles Ethernet interrupt requests.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void ETHERNET_Handler(void)
{
}

/*******************************************************************************
* Function Name  : RITINT_Handler
* Description    : This function handles repetitive timer interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void RITINT_Handler(void)
{
}

/*******************************************************************************
* Function Name  : MC_PWM_Handler
* Description    : This function handles motor control pwm interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void MC_PWM_Handler(void)
{
}

/*******************************************************************************
* Function Name  : QENC_Handler
* Description    : This function handles the quadraturew encoder interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void QENC_Handler(void)
{
}

/*******************************************************************************
* Function Name  : PLL1_Handler
* Description    : This function handles PLL1 (USB-PLL) interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void PLL1_Handler(void)
{
}

/*******************************************************************************
* Function Name  : USB_ACT_Handler
* Description    : This function handles USB activity interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USB_ACT_Handler(void)
{
}

/*******************************************************************************
* Function Name  : CAN_ACT_Handler
* Description    : This function handles CAN activity interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void CAN_ACT_Handler(void)
{
}

/*******************************************************************************
* Function Name  : DefaultHandler
* Description    : Interrupt entry point for any unexpected exeption
*                  should never been executed
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/

void DefaultHandler(void)
{
   // Infinite loop.
   while(1)
   {
   }
}
