 /********************************************************************
 * Project:    Cortex-M3 Template
 * File:       main.c
 *
 * System:     Cortex M3
 * Compiler:   GNU GCC
 *
 * Date:       2009-05-12
 * Author:     Application@Hitex.de
 *
 * Rights:     Hitex Development Tools GmbH
 *             Greschbachstr. 12
 *             D-76229 Karlsruhe
 ********************************************************************
 * Description:
 * main.c
 * main code for applications based on Cortex M3
 ********************************************************************
 * History:
 *
 * Initial revision : 2009-05-12
 ********************************************************************
 * This is a preliminary version.
 *
 * WARRANTY:  HITEX warrants that the media on which the SOFTWARE is
 * furnished is free from defects in materials and workmanship under
 * normal use and service for a period of ninety (90) days. HITEX entire
 * liability and your exclusive remedy shall be the replacement of the
 * SOFTWARE if the media is defective. This Warranty is void if failure
 * of the media resulted from unauthorized modification, accident, abuse,
 * or misapplication.
 *
 * DISCLAIMER:  OTHER THAN THE ABOVE WARRANTY, THE SOFTWARE IS FURNISHED
 * "AS IS" WITHOUT WARRANTY OF ANY KIND. HITEX DISCLAIMS ALL OTHER WARRANTIES,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * NEITHER HITEX NOR ITS AFFILIATES SHALL BE LIABLE FOR ANY DAMAGES ARISING
 * OUT OF THE USE OF OR INABILITY TO USE THE SOFTWARE, INCLUDING DAMAGES FOR
 * LOSS OF PROFITS, BUSINESS INTERRUPTION, OR ANY SPECIAL, INCIDENTAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES EVEN IF HITEX HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGES.
 ********************************************************************/

#include "main.h"

type_InterruptTest IQtest;
FlashSign_t bistTest;

void initController(void)
{
	SC->SCS = 0x00000020;		//Enable Main clock
	
	// Iintialise Timers 
	SC->PCONP |= 0x00c00006;		//enable Power for all Timers
	SC->PCLKSEL0 |= 0x00000014;		//clk signal for all Timers
	SC->PCLKSEL1 |= 0x00005000;

	//Timer 0
	TIM0->TCR = 0x00000002;				//reset TC
	
	TIM0->PR = 0x00000000;				//prescaler = 0
	TIM0->CTCR = 0x00000000;			//timer mode

	TIM0->MR0 = 0x0000FFFF;				//match value
	TIM0->MCR = 0x00000003;				//generate interrupt and reset TimerCounter on Match0 and reset TimerCounter

	TIM0->TCR = 0x00000001;				//enable TC

	NVIC->ISER[0] = 0x00000002;				//enable Timer0 interrupt

	//Timer 1
	TIM1->TCR = 0x00000002;				//reset TC
	
	TIM1->PR = 0x00000000;				//prescaler = 0
	TIM1->CTCR = 0x00000000;			//timer mode

	TIM1->MR0 = 0x001FFFFF;				//match value
	TIM1->MCR = 0x00000003;				//generate interrupt and reset TimerCounter on Match0 and reset TimerCounter

	TIM1->TCR = 0x00000001;				//enable TC

	NVIC->ISER[0] = 0x00000004;				//enable Timer0 interrupt

	//Timer2
	TIM2->TCR = 0x00000002;				//reset TC
	
	TIM2->PR = 0x00000000;				//prescaler = 0
	TIM2->CTCR = 0x00000000;			//timer mode

	TIM2->MR0 = 0x002FFFFF;				//match value
	TIM2->MCR = 0x00000003;				//generate interrupt and reset TimerCounter on Match0 and reset TimerCounter

	TIM2->TCR = 0x00000001;				//enable TC

	NVIC->ISER[0] = 0x00000008;				//enable Timer0 interrupt

	//Timer3
	TIM3->TCR = 0x00000002;				//reset TC
	
	TIM3->PR = 0x00000000;				//prescaler = 0
	TIM3->CTCR = 0x00000000;			//timer mode

	TIM3->MR0 = 0x003FFFFF;				//match value
	TIM3->MCR = 0x00000003;				//generate interrupt and reset TimerCounter on Match0 and reset TimerCounter

	TIM3->TCR = 0x00000001;				//enable TC

	NVIC->ISER[0] = 0x00000010;				//enable Timer0 interrupt

	//Initialise RTC
	SC->PCONP |= 0x00000200;		//enable Power for all Timers

	RTC->CCR = 0x00000002;

	RTC->CIIR = 0x00000001;
	RTC->CCR = 0x00000001;

	NVIC->ISER[0] = 0x00020000;				//enable RTC interrupt
}

int main (void)
{
	BOOL Result = FALSE;

	initController();
	
	{
		IEC60335_initClockTest(10000, 30000, 58, 64);//UINT32 timerOccThreshold, UINT32 rtcOccThreshold, UINT32 timerLowerBound, UINT32 timerUpperBound

		IEC60335_InitInterruptTest(&IQtest, 0, 200,3);

		StartHardSignatureGen(0x1000,0x1000,&bistTest);
	}

	while (1)
	{
		{
			type_secured_UINT32 test = IEC60335_CriticalDataInitialise(12345678);
//			type_secured_UINT32 test = { 12345678, ~12345678};	// not allowed
//			test = IEC60335_CriticalDataInitialise(12345678);	// not allowed
		
			Result = IEC60335_CriticalDataCheck(test);
			
			test.data = 0;										//not allowed
		
			Result = IEC60335_CriticalDataCheck(test);
		
			IEC60335_CriticalDataWrite(test, 0x87654321);


			//benutzung ramtest fr datenstrukturen.........

			//test durch hiscript.....
		
			Result = IEC60335_Clocktest_MainLoopHandler();
		
			Result = IEC60335_FLASHtest_BIST (0x1000,0x1000,&bistTest,FLASH_HARD_SIGN);
		
			Result = IEC60335_B_PCTest_BIST();
		
			Result = IEC60335_RAMtest_BIST (0x100, 0x10);
		} 
	}
}

/************************************** EOF *********************************/