/********************************************************************
 * Project:    Cortex-M3-Template
 * File:       interrupt.h
 *
 * System:     Cortex M3
 * Compiler:   GNU GCC 
 *
 * Date:       2009-05-12
 * Author:     Application@Hitex.de
 *
 * Rights:     Hitex Development Tools GmbH
 *             Greschbachstr. 12
 *             D-76229 Karlsruhe
 ********************************************************************
 * Description:
 * interrupt.h
 * interrupt routines prototypes code for applications based on Cortex M3
 ********************************************************************
 * History:
 *
 * Initial revision : 2008-02-05
 ********************************************************************
 * This is a preliminary version.
 *
 * WARRANTY:  HITEX warrants that the media on which the SOFTWARE is
 * furnished is free from defects in materials and workmanship under
 * normal use and service for a period of ninety (90) days. HITEX entire
 * liability and your exclusive remedy shall be the replacement of the
 * SOFTWARE if the media is defective. This Warranty is void if failure
 * of the media resulted from unauthorized modification, accident, abuse,
 * or misapplication.
 *
 * DISCLAIMER:  OTHER THAN THE ABOVE WARRANTY, THE SOFTWARE IS FURNISHED
 * "AS IS" WITHOUT WARRANTY OF ANY KIND. HITEX DISCLAIMS ALL OTHER WARRANTIES,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * NEITHER HITEX NOR ITS AFFILIATES SHALL BE LIABLE FOR ANY DAMAGES ARISING
 * OUT OF THE USE OF OR INABILITY TO USE THE SOFTWARE, INCLUDING DAMAGES FOR
 * LOSS OF PROFITS, BUSINESS INTERRUPTION, OR ANY SPECIAL, INCIDENTAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES EVEN IF HITEX HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGES.
 ********************************************************************/

// Define to prevent recursive inclusion
#ifndef __INTERRUPT_H
#define __INTERRUPT_H


void NMIException(void);
void HardFaultException(void);
void MemManageException(void);
void BusFaultException(void);
void UsageFaultException(void);
void DebugMonitor(void);
void SVCHandler(void);
void PendSVC(void);
void SysTickHandler(void);

void WDINT_Handler(void);
void TIMER0_Handler(void);
void TIMER0_Handler(void);
void TIMER1_Handler(void);
void TIMER2_Handler(void);
void TIMER3_Handler(void);
void UART0_Handler(void);
void UART1_Handler(void);
void UART2_Handler(void);
void UART3_Handler(void);
void PWM1_Handler(void);
void I2C0_Handler(void);
void I2C1_Handler(void);
void I2C2_Handler(void);
void SPI_Handler(void);
void SSP0_Handler(void);
void SSP1_Handler(void);
void PLL0_Handler(void);
void RTC_Handler(void);
void EXTI0_Handler(void);
void EXTI1_Handler(void);
void EXTI2_Handler(void);
void EXTI3_Handler(void);
void ADC_Handler(void);
void BOD_Handler(void);
void USB_Handler(void);
void CAN_Handler(void);
void GP_DMA_Handler(void);
void I2S_Handler(void);
void ETHERNET_Handler(void);
void RITINT_Handler(void);
void MC_PWM_Handler(void);
void QENC_Handler(void);
void PLL1_Handler(void);
void USB_ACT_Handler(void);
void CAN_ACT_Handler(void);

void DefaultHandler(void);
#endif // __INTERRUPT_H

/*****************************END OF FILE****************************/
