/*****************************************************************************
 *   target.c:  Target C file for NXP LPC17xx Family Microprocessors
 *
 *   Copyright(C) 2008, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2008.08.20  ver 1.00    Prelimnary version, first Release
 *
*****************************************************************************/
#include "LPC17xx.h"
#include "type.h"
#include "target.h"

/******************************************************************************
** Function name:		TargetInit
**
** Descriptions:		Initialize the target board; it is called in a necessary 
**						place, change it as needed
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
void TargetInit(void)
{
  /* Add your codes here */
  return;
}

/******************************************************************************
** Function name:		GPIOResetInit
**
** Descriptions:		Initialize the target board before running the main() 
**				function; User may change it as needed, but may not 
**				deleted it.
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
void GPIOResetInit(void)
{
  /* Reset all GPIO pins to default: primary function */
  LPC_PINCON->PINSEL0 	= 0x00000000;
  LPC_PINCON->PINSEL1 	= 0x00000000;
  LPC_PINCON->PINSEL2 	= 0x00000000;
  LPC_PINCON->PINSEL3 	= 0x00000000;
  LPC_PINCON->PINSEL4 	= 0x00000000;
  LPC_PINCON->PINSEL5 	= 0x00000000;
  LPC_PINCON->PINSEL6 	= 0x00000000;
  LPC_PINCON->PINSEL7 	= 0x00000000;
  LPC_PINCON->PINSEL8 	= 0x00000000;
  LPC_PINCON->PINSEL9 	= 0x00000000;
  LPC_PINCON->PINSEL10 	= 0x00000000;
    
  LPC_GPIO0->FIODIR		= 0x00000000;
  LPC_GPIO1->FIODIR		= 0x00000000;
  LPC_GPIO2->FIODIR		= 0x00000000;
  LPC_GPIO3->FIODIR		= 0x00000000;
  LPC_GPIO4->FIODIR		= 0x00000000;

  LPC_GPIO0->FIOSET		= 0x00000000;
  LPC_GPIO1->FIOSET		= 0x00000000;
  LPC_GPIO2->FIOSET		= 0x00000000;
  LPC_GPIO3->FIOSET		= 0x00000000;
  LPC_GPIO4->FIOSET		= 0x00000000;

  return;        
}

/******************************************************************************
** Function name:		ConfigurePLL
**
** Descriptions:		Configure PLL switching to main OSC instead of IRC
**						at power up and wake up from power down. 
**						This routine is used in TargetResetInit() and those
**						examples using power down and wake up such as
**						USB suspend to resume, ethernet WOL, and power management
**						example
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
void ConfigurePLL(void)
{
  DWORD MValue, NValue, PValue;

  if ( LPC_SC->PLL0STAT & (1 << 25) )
  {
	LPC_SC->PLL0CON = 1;			/* Enable PLL, disconnected */
	LPC_SC->PLL0FEED = 0xaa;
	LPC_SC->PLL0FEED = 0x55;
  }

  LPC_SC->PLL0CON = 0;				/* Disable PLL, disconnected */
  LPC_SC->PLL0FEED = 0xaa;
  LPC_SC->PLL0FEED = 0x55;
    
  LPC_SC->SCS |= 0x20;			/* Enable main OSC */
  while( !(LPC_SC->SCS & 0x40) );	/* Wait until main OSC is usable */

  LPC_SC->CLKSRCSEL = 0x1;		/* select main OSC, 12MHz, as the PLL clock source */

  LPC_SC->PLL0CFG = PLL0_MValue | (PLL0_NValue << 16);
  LPC_SC->PLL0FEED = 0xaa;
  LPC_SC->PLL0FEED = 0x55;
      
  LPC_SC->PLL0CON = 1;				/* Enable PLL, disconnected */
  LPC_SC->PLL0FEED = 0xaa;
  LPC_SC->PLL0FEED = 0x55;

  LPC_SC->CCLKCFG = CCLKDivValue;	/* Set clock divider */

  while ( ((LPC_SC->PLL0STAT & (1 << 26)) == 0) );	/* Check lock bit status */
    
  MValue = LPC_SC->PLL0STAT & 0x00007FFF;
  NValue = (LPC_SC->PLL0STAT & 0x00FF0000) >> 16;
  while ((MValue != PLL0_MValue) && ( NValue != PLL0_NValue) );

  LPC_SC->PLL0CON = 3;				/* enable and connect */
  LPC_SC->PLL0FEED = 0xaa;
  LPC_SC->PLL0FEED = 0x55;
  while ( ((LPC_SC->PLL0STAT & (1 << 25)) == 0) );	/* Check connect bit status */

#if USE_USB
  if ( LPC_SC->PLL1STAT & (1 << 9) )
  {
	LPC_SC->PLL1CON = 1;			/* Enable PLL, disconnected */
	LPC_SC->PLL1FEED = 0xaa;
	LPC_SC->PLL1FEED = 0x55;
  }

  LPC_SC->PLL1CON = 0;				/* Disable PLL, disconnected */
  LPC_SC->PLL1FEED = 0xaa;
  LPC_SC->PLL1FEED = 0x55;

  LPC_SC->PLL1CFG = PLL1_MValue | (PLL1_PValue << 5);
  LPC_SC->PLL1FEED = 0xaa;
  LPC_SC->PLL1FEED = 0x55;
      
  LPC_SC->PLL1CON = 1;				/* Enable PLL, disconnected */
  LPC_SC->PLL1FEED = 0xaa;
  LPC_SC->PLL1FEED = 0x55;
  while ( ((LPC_SC->PLL1STAT & (1 << 10)) == 0) );	/* Check lock bit status */

  MValue = LPC_SC->PLL1STAT & 0x0000001F;
  PValue = (LPC_SC->PLL1STAT & 0x00000060) >> 5;
  while ((MValue != PLL1_MValue) && ( PValue != PLL1_PValue) );

  LPC_SC->PLL1CON = 3;				/* enable and connect */
  LPC_SC->PLL1FEED = 0xaa;
  LPC_SC->PLL1FEED = 0x55;
  while ( ((LPC_SC->PLL1STAT & (1 << 9)) == 0) );	/* Check connect bit status */
#endif

  return;
}

/******************************************************************************
** Function name:		TargetResetInit
**
** Descriptions:		Initialize the target board before running the main() 
**						function; User may change it as needed, but may not 
**						deleted it.
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
void TargetResetInit(void)
{
#if USE_USB
//  PCONP |= 0x80000000;		/* Turn On USB PCLK */
#endif
  /* Configure PLL, switch from IRC to Main OSC */
  ConfigurePLL();

  /* Set system timers for each component */
#if (Fpclk / (Fcclk / 4)) == 1
  LPC_SC->PCLKSEL0 = 0x00000000;	/* PCLK is 1/4 CCLK */
  LPC_SC->PCLKSEL1 = 0x00000000;
#endif
#if (Fpclk / (Fcclk / 4)) == 2
  LPC_SC->PCLKSEL0 = 0xAAAAAAAA;	/* PCLK is 1/2 CCLK */
  LPC_SC->PCLKSEL1 = 0xAAAAAAAA;	 
#endif
#if (Fpclk / (Fcclk / 4)) == 4
  LPC_SC->PCLKSEL0 = 0x55555555;	/* PCLK is the same as CCLK */
  LPC_SC->PCLKSEL1 = 0x55555555;	
#endif

  GPIOResetInit();

  return;
}

/******************************************************************************
**                            End Of File
******************************************************************************/
