#ifndef __cb_int_
#define __cb_int_

#include "IEC60335.h"

/*! \brief Structure for interrupt testing.

	For each interrupt, which has to be tested, there has to be one instance of this structure.
	To initialise the struct, you have to use the initialisation function
	\a IEC60335_InitInterruptTest(type_InterruptTest *pIRQ, UINT32 lowerBound, UINT32 upperBound, UINT32 individualValue).
*/
typedef struct tag_IntTest
{
	UINT32 Count;			/*!< The counter Variable*/

	UINT32 lower;			/*!< The estimated minimum count of interrupt occurencies*/
	UINT32 upper;			/*!< The estimated maximum count of interrupt occurencies*/
	
	UINT32 individualValue;	/*!< The individual up-counting value*/
} type_InterruptTest;

/*! \brief Initialises an interrupt test. */
void IEC60335_InitInterruptTest(type_InterruptTest *pIRQ, UINT32 lowerBound, UINT32 upperBound, UINT32 individualValue);

/*! \brief To be called inside the interrupt. */
void IEC60335_InterruptOcurred(type_InterruptTest *pIRQ);
/*! \brief Checks the interrupt. */
type_testResult IEC60335_InterruptCheck(type_InterruptTest *pIRQ);

#endif
