/*******************************************************************************************
  Data table provides the bitmap data of each character.

  To get the starting data offset of character 'A', you can use the following expression:

     const unsigned char index = index_table['A'];
     const unsigned int offset = offset_table[index];
     const unsigned char *pData = data_table[offset];

 *******************************************************************************************/
const unsigned char font_data_table[] = {

/* character 0x0020 (' '): (width=8, offset=0) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x0021 ('!'): (width=8, offset=15) */
0x00, 0x00, 0x00, 0x18, 0x3C, 0x3C, 0x3C, 0x18, 
0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 

/* character 0x0022 ('"'): (width=8, offset=30) */
0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x0023 ('#'): (width=8, offset=45) */
0x00, 0x00, 0x00, 0x36, 0x36, 0x7F, 0x36, 0x36, 
0x36, 0x7F, 0x36, 0x36, 0x00, 0x00, 0x00, 

/* character 0x0024 ('$'): (width=8, offset=60) */
0x00, 0x18, 0x18, 0x3C, 0x66, 0x60, 0x30, 0x18, 
0x0C, 0x06, 0x66, 0x3C, 0x18, 0x18, 0x00, 

/* character 0x0025 ('%'): (width=8, offset=75) */
0x00, 0x00, 0x70, 0xD8, 0xDA, 0x76, 0x0C, 0x18, 
0x30, 0x6E, 0x5B, 0x1B, 0x0E, 0x00, 0x00, 

/* character 0x0026 ('&'): (width=8, offset=90) */
0x00, 0x00, 0x00, 0x38, 0x6C, 0x6C, 0x38, 0x60, 
0x6F, 0x66, 0x66, 0x3B, 0x00, 0x00, 0x00, 

/* character 0x0027 ('''): (width=8, offset=105) */
0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x0028 ('('): (width=8, offset=120) */
0x00, 0x00, 0x00, 0x0C, 0x18, 0x18, 0x30, 0x30, 
0x30, 0x30, 0x30, 0x18, 0x18, 0x0C, 0x00, 

/* character 0x0029 (')'): (width=8, offset=135) */
0x00, 0x00, 0x00, 0x30, 0x18, 0x18, 0x0C, 0x0C, 
0x0C, 0x0C, 0x0C, 0x18, 0x18, 0x30, 0x00, 

/* character 0x002A ('*'): (width=8, offset=150) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x1C, 0x7F, 
0x1C, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x002B ('+'): (width=8, offset=165) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7E, 
0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x002C (','): (width=8, offset=180) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x1C, 0x1C, 0x0C, 0x18, 0x00, 

/* character 0x002D ('-'): (width=8, offset=195) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x002E ('.'): (width=8, offset=210) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x1C, 0x1C, 0x00, 0x00, 0x00, 

/* character 0x002F ('/'): (width=8, offset=225) */
0x00, 0x00, 0x00, 0x06, 0x06, 0x0C, 0x0C, 0x18, 
0x18, 0x30, 0x30, 0x60, 0x60, 0x00, 0x00, 

/* character 0x0030 ('0'): (width=8, offset=240) */
0x00, 0x00, 0x00, 0x1E, 0x33, 0x37, 0x37, 0x33, 
0x3B, 0x3B, 0x33, 0x1E, 0x00, 0x00, 0x00, 

/* character 0x0031 ('1'): (width=8, offset=255) */
0x00, 0x00, 0x00, 0x0C, 0x1C, 0x7C, 0x0C, 0x0C, 
0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 

/* character 0x0032 ('2'): (width=8, offset=270) */
0x00, 0x00, 0x00, 0x3C, 0x66, 0x66, 0x06, 0x0C, 
0x18, 0x30, 0x60, 0x7E, 0x00, 0x00, 0x00, 

/* character 0x0033 ('3'): (width=8, offset=285) */
0x00, 0x00, 0x00, 0x3C, 0x66, 0x66, 0x06, 0x1C, 
0x06, 0x66, 0x66, 0x3C, 0x00, 0x00, 0x00, 

/* character 0x0034 ('4'): (width=8, offset=300) */
0x00, 0x00, 0x00, 0x30, 0x30, 0x36, 0x36, 0x36, 
0x66, 0x7F, 0x06, 0x06, 0x00, 0x00, 0x00, 

/* character 0x0035 ('5'): (width=8, offset=315) */
0x00, 0x00, 0x00, 0x7E, 0x60, 0x60, 0x60, 0x7C, 
0x06, 0x06, 0x0C, 0x78, 0x00, 0x00, 0x00, 

/* character 0x0036 ('6'): (width=8, offset=330) */
0x00, 0x00, 0x00, 0x1C, 0x18, 0x30, 0x7C, 0x66, 
0x66, 0x66, 0x66, 0x3C, 0x00, 0x00, 0x00, 

/* character 0x0037 ('7'): (width=8, offset=345) */
0x00, 0x00, 0x00, 0x7E, 0x06, 0x0C, 0x0C, 0x18, 
0x18, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 

/* character 0x0038 ('8'): (width=8, offset=360) */
0x00, 0x00, 0x00, 0x3C, 0x66, 0x66, 0x76, 0x3C, 
0x6E, 0x66, 0x66, 0x3C, 0x00, 0x00, 0x00, 

/* character 0x0039 ('9'): (width=8, offset=375) */
0x00, 0x00, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x66, 
0x3E, 0x0C, 0x18, 0x38, 0x00, 0x00, 0x00, 

/* character 0x003A (':'): (width=8, offset=390) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1C, 0x00, 
0x00, 0x00, 0x1C, 0x1C, 0x00, 0x00, 0x00, 

/* character 0x003B (';'): (width=8, offset=405) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1C, 0x00, 
0x00, 0x00, 0x1C, 0x1C, 0x0C, 0x18, 0x00, 

/* character 0x003C ('<'): (width=8, offset=420) */
0x00, 0x00, 0x00, 0x06, 0x0C, 0x18, 0x30, 0x60, 
0x30, 0x18, 0x0C, 0x06, 0x00, 0x00, 0x00, 

/* character 0x003D ('='): (width=8, offset=435) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 
0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x003E ('>'): (width=8, offset=450) */
0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0C, 0x06, 
0x0C, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 

/* character 0x003F ('?'): (width=8, offset=465) */
0x00, 0x00, 0x00, 0x3C, 0x66, 0x66, 0x0C, 0x18, 
0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 

/* character 0x0040 ('@'): (width=8, offset=480) */
0x00, 0x00, 0x00, 0x7E, 0xC3, 0xC3, 0xCF, 0xDB, 
0xDB, 0xCF, 0xC0, 0x7F, 0x00, 0x00, 0x00, 

/* character 0x0041 ('A'): (width=8, offset=495) */
0x00, 0x00, 0x00, 0x18, 0x3C, 0x66, 0x66, 0x66, 
0x7E, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 

/* character 0x0042 ('B'): (width=8, offset=510) */
0x00, 0x00, 0x00, 0x7C, 0x66, 0x66, 0x66, 0x7C, 
0x66, 0x66, 0x66, 0x7C, 0x00, 0x00, 0x00, 

/* character 0x0043 ('C'): (width=8, offset=525) */
0x00, 0x00, 0x00, 0x3C, 0x66, 0x66, 0x60, 0x60, 
0x60, 0x66, 0x66, 0x3C, 0x00, 0x00, 0x00, 

/* character 0x0044 ('D'): (width=8, offset=540) */
0x00, 0x00, 0x00, 0x78, 0x6C, 0x66, 0x66, 0x66, 
0x66, 0x66, 0x6C, 0x78, 0x00, 0x00, 0x00, 

/* character 0x0045 ('E'): (width=8, offset=555) */
0x00, 0x00, 0x00, 0x7E, 0x60, 0x60, 0x60, 0x7C, 
0x60, 0x60, 0x60, 0x7E, 0x00, 0x00, 0x00, 

/* character 0x0046 ('F'): (width=8, offset=570) */
0x00, 0x00, 0x00, 0x7E, 0x60, 0x60, 0x60, 0x7C, 
0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 

/* character 0x0047 ('G'): (width=8, offset=585) */
0x00, 0x00, 0x00, 0x3C, 0x66, 0x66, 0x60, 0x60, 
0x6E, 0x66, 0x66, 0x3E, 0x00, 0x00, 0x00, 

/* character 0x0048 ('H'): (width=8, offset=600) */
0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x7E, 
0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 

/* character 0x0049 ('I'): (width=8, offset=615) */
0x00, 0x00, 0x00, 0x3C, 0x18, 0x18, 0x18, 0x18, 
0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 

/* character 0x004A ('J'): (width=8, offset=630) */
0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 
0x06, 0x66, 0x66, 0x3C, 0x00, 0x00, 0x00, 

/* character 0x004B ('K'): (width=8, offset=645) */
0x00, 0x00, 0x00, 0x66, 0x66, 0x6C, 0x6C, 0x78, 
0x6C, 0x6C, 0x66, 0x66, 0x00, 0x00, 0x00, 

/* character 0x004C ('L'): (width=8, offset=660) */
0x00, 0x00, 0x00, 0x60, 0x60, 0x60, 0x60, 0x60, 
0x60, 0x60, 0x60, 0x7E, 0x00, 0x00, 0x00, 

/* character 0x004D ('M'): (width=8, offset=675) */
0x00, 0x00, 0x00, 0x63, 0x63, 0x77, 0x6B, 0x6B, 
0x6B, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 

/* character 0x004E ('N'): (width=8, offset=690) */
0x00, 0x00, 0x00, 0x63, 0x63, 0x73, 0x7B, 0x6F, 
0x67, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 

/* character 0x004F ('O'): (width=8, offset=705) */
0x00, 0x00, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x66, 
0x66, 0x66, 0x66, 0x3C, 0x00, 0x00, 0x00, 

/* character 0x0050 ('P'): (width=8, offset=720) */
0x00, 0x00, 0x00, 0x7C, 0x66, 0x66, 0x66, 0x7C, 
0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 

/* character 0x0051 ('Q'): (width=8, offset=735) */
0x00, 0x00, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x66, 
0x66, 0x66, 0x66, 0x3C, 0x0C, 0x06, 0x00, 

/* character 0x0052 ('R'): (width=8, offset=750) */
0x00, 0x00, 0x00, 0x7C, 0x66, 0x66, 0x66, 0x7C, 
0x6C, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 

/* character 0x0053 ('S'): (width=8, offset=765) */
0x00, 0x00, 0x00, 0x3C, 0x66, 0x60, 0x30, 0x18, 
0x0C, 0x06, 0x66, 0x3C, 0x00, 0x00, 0x00, 

/* character 0x0054 ('T'): (width=8, offset=780) */
0x00, 0x00, 0x00, 0x7E, 0x18, 0x18, 0x18, 0x18, 
0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 

/* character 0x0055 ('U'): (width=8, offset=795) */
0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 
0x66, 0x66, 0x66, 0x3C, 0x00, 0x00, 0x00, 

/* character 0x0056 ('V'): (width=8, offset=810) */
0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 
0x66, 0x66, 0x3C, 0x18, 0x00, 0x00, 0x00, 

/* character 0x0057 ('W'): (width=8, offset=825) */
0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x6B, 0x6B, 
0x6B, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 

/* character 0x0058 ('X'): (width=8, offset=840) */
0x00, 0x00, 0x00, 0x66, 0x66, 0x34, 0x18, 0x18, 
0x2C, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 

/* character 0x0059 ('Y'): (width=8, offset=855) */
0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3C, 
0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 

/* character 0x005A ('Z'): (width=8, offset=870) */
0x00, 0x00, 0x00, 0x7E, 0x06, 0x06, 0x0C, 0x18, 
0x30, 0x60, 0x60, 0x7E, 0x00, 0x00, 0x00, 

/* character 0x005B ('['): (width=8, offset=885) */
0x00, 0x00, 0x00, 0x3C, 0x30, 0x30, 0x30, 0x30, 
0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3C, 

/* character 0x005C ('\'): (width=8, offset=900) */
0x00, 0x00, 0x00, 0x60, 0x60, 0x30, 0x30, 0x18, 
0x18, 0x0C, 0x0C, 0x06, 0x06, 0x00, 0x00, 

/* character 0x005D (']'): (width=8, offset=915) */
0x00, 0x00, 0x00, 0x3C, 0x0C, 0x0C, 0x0C, 0x0C, 
0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3C, 

/* character 0x005E ('^'): (width=8, offset=930) */
0x00, 0x18, 0x3C, 0x66, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x005F ('_'): (width=8, offset=945) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 

/* character 0x0060 ('`'): (width=8, offset=960) */
0x00, 0x38, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x0061 ('a'): (width=8, offset=975) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x06, 0x06, 
0x3E, 0x66, 0x66, 0x3E, 0x00, 0x00, 0x00, 

/* character 0x0062 ('b'): (width=8, offset=990) */
0x00, 0x00, 0x00, 0x60, 0x60, 0x7C, 0x66, 0x66, 
0x66, 0x66, 0x66, 0x7C, 0x00, 0x00, 0x00, 

/* character 0x0063 ('c'): (width=8, offset=1005) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x66, 0x60, 
0x60, 0x60, 0x66, 0x3C, 0x00, 0x00, 0x00, 

/* character 0x0064 ('d'): (width=8, offset=1020) */
0x00, 0x00, 0x00, 0x06, 0x06, 0x3E, 0x66, 0x66, 
0x66, 0x66, 0x66, 0x3E, 0x00, 0x00, 0x00, 

/* character 0x0065 ('e'): (width=8, offset=1035) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x66, 0x66, 
0x7E, 0x60, 0x60, 0x3C, 0x00, 0x00, 0x00, 

/* character 0x0066 ('f'): (width=8, offset=1050) */
0x00, 0x00, 0x00, 0x1E, 0x30, 0x30, 0x30, 0x7E, 
0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 

/* character 0x0067 ('g'): (width=8, offset=1065) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x66, 0x66, 
0x66, 0x66, 0x66, 0x3E, 0x06, 0x06, 0x7C, 

/* character 0x0068 ('h'): (width=8, offset=1080) */
0x00, 0x00, 0x00, 0x60, 0x60, 0x7C, 0x66, 0x66, 
0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 

/* character 0x0069 ('i'): (width=8, offset=1095) */
0x00, 0x00, 0x18, 0x18, 0x00, 0x78, 0x18, 0x18, 
0x18, 0x18, 0x18, 0x7E, 0x00, 0x00, 0x00, 

/* character 0x006A ('j'): (width=8, offset=1110) */
0x00, 0x00, 0x0C, 0x0C, 0x00, 0x3C, 0x0C, 0x0C, 
0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x78, 

/* character 0x006B ('k'): (width=8, offset=1125) */
0x00, 0x00, 0x00, 0x60, 0x60, 0x66, 0x66, 0x6C, 
0x78, 0x6C, 0x66, 0x66, 0x00, 0x00, 0x00, 

/* character 0x006C ('l'): (width=8, offset=1140) */
0x00, 0x00, 0x00, 0x78, 0x18, 0x18, 0x18, 0x18, 
0x18, 0x18, 0x18, 0x7E, 0x00, 0x00, 0x00, 

/* character 0x006D ('m'): (width=8, offset=1155) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x6B, 0x6B, 
0x6B, 0x6B, 0x6B, 0x63, 0x00, 0x00, 0x00, 

/* character 0x006E ('n'): (width=8, offset=1170) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x66, 0x66, 
0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 

/* character 0x006F ('o'): (width=8, offset=1185) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x66, 0x66, 
0x66, 0x66, 0x66, 0x3C, 0x00, 0x00, 0x00, 

/* character 0x0070 ('p'): (width=8, offset=1200) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x66, 0x66, 
0x66, 0x66, 0x66, 0x7C, 0x60, 0x60, 0x60, 

/* character 0x0071 ('q'): (width=8, offset=1215) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x66, 0x66, 
0x66, 0x66, 0x66, 0x3E, 0x06, 0x06, 0x06, 

/* character 0x0072 ('r'): (width=8, offset=1230) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x6E, 0x70, 
0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 

/* character 0x0073 ('s'): (width=8, offset=1245) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x60, 0x60, 
0x3C, 0x06, 0x06, 0x7C, 0x00, 0x00, 0x00, 

/* character 0x0074 ('t'): (width=8, offset=1260) */
0x00, 0x00, 0x00, 0x30, 0x30, 0x7E, 0x30, 0x30, 
0x30, 0x30, 0x30, 0x1E, 0x00, 0x00, 0x00, 

/* character 0x0075 ('u'): (width=8, offset=1275) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 
0x66, 0x66, 0x66, 0x3E, 0x00, 0x00, 0x00, 

/* character 0x0076 ('v'): (width=8, offset=1290) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 
0x66, 0x66, 0x3C, 0x18, 0x00, 0x00, 0x00, 

/* character 0x0077 ('w'): (width=8, offset=1305) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x6B, 0x6B, 
0x6B, 0x6B, 0x36, 0x36, 0x00, 0x00, 0x00, 

/* character 0x0078 ('x'): (width=8, offset=1320) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x3C, 
0x18, 0x3C, 0x66, 0x66, 0x00, 0x00, 0x00, 

/* character 0x0079 ('y'): (width=8, offset=1335) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 
0x66, 0x66, 0x66, 0x3C, 0x0C, 0x18, 0xF0, 

/* character 0x007A ('z'): (width=8, offset=1350) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x06, 0x0C, 
0x18, 0x30, 0x60, 0x7E, 0x00, 0x00, 0x00, 

/* character 0x007B ('{'): (width=8, offset=1365) */
0x00, 0x00, 0x00, 0x0C, 0x18, 0x18, 0x18, 0x30, 
0x60, 0x30, 0x18, 0x18, 0x18, 0x0C, 0x00, 

/* character 0x007C ('|'): (width=8, offset=1380) */
0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 
0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 

/* character 0x007D ('}'): (width=8, offset=1395) */
0x00, 0x00, 0x00, 0x30, 0x18, 0x18, 0x18, 0x0C, 
0x06, 0x0C, 0x18, 0x18, 0x18, 0x30, 0x00, 

/* character 0x007E ('~'): (width=8, offset=1410) */
0x00, 0x00, 0x00, 0x71, 0xDB, 0x8E, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x007F (''): (width=8, offset=1425) */
0x00, 0x00, 0x00, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 
0x7E, 0x7E, 0x7E, 0x7E, 0x00, 0x00, 0x00, 

};


/*******************************************************************************************
  Index table is used to find the mapping index of a character.

  If you can find a simple mathematical expression for index mapping, you can use that.
  If you do not have such a mathematical expression, this index table is just for you.

  To get the index of character 'A', you can use the following expression:

     const unsigned char index = index_table['A'];

 *******************************************************************************************/
const unsigned char font_index_table[] = {
/*		index   hexcode   decimal  char */
/*		=====   =======   =======  ==== */
  		  0, /*   00          0     .   */
  		  0, /*   01          1     .   */
  		  0, /*   02          2     .   */
  		  0, /*   03          3     .   */
  		  0, /*   04          4     .   */
  		  0, /*   05          5     .   */
  		  0, /*   06          6     .   */
  		  0, /*   07          7     .   */
  		  0, /*   08          8     .   */
  		  0, /*   09          9     .   */
  		  0, /*   0A         10     .   */
  		  0, /*   0B         11     .   */
  		  0, /*   0C         12     .   */
  		  0, /*   0D         13     .   */
  		  0, /*   0E         14     .   */
  		  0, /*   0F         15     .   */
  		  0, /*   10         16     .   */
  		  0, /*   11         17     .   */
  		  0, /*   12         18     .   */
  		  0, /*   13         19     .   */
  		  0, /*   14         20     .   */
  		  0, /*   15         21     .   */
  		  0, /*   16         22     .   */
  		  0, /*   17         23     .   */
  		  0, /*   18         24     .   */
  		  0, /*   19         25     .   */
  		  0, /*   1A         26     .   */
  		  0, /*   1B         27     .   */
  		  0, /*   1C         28     .   */
  		  0, /*   1D         29     .   */
  		  0, /*   1E         30     .   */
  		  0, /*   1F         31     .   */
  		  0, /*   20         32         */
  		  1, /*   21         33     !   */
  		  2, /*   22         34     "   */
  		  3, /*   23         35     #   */
  		  4, /*   24         36     $   */
  		  5, /*   25         37     %   */
  		  6, /*   26         38     &   */
  		  7, /*   27         39     '   */
  		  8, /*   28         40     (   */
  		  9, /*   29         41     )   */
  		 10, /*   2A         42     *   */
  		 11, /*   2B         43     +   */
  		 12, /*   2C         44     ,   */
  		 13, /*   2D         45     -   */
  		 14, /*   2E         46     .   */
  		 15, /*   2F         47     /   */
  		 16, /*   30         48     0   */
  		 17, /*   31         49     1   */
  		 18, /*   32         50     2   */
  		 19, /*   33         51     3   */
  		 20, /*   34         52     4   */
  		 21, /*   35         53     5   */
  		 22, /*   36         54     6   */
  		 23, /*   37         55     7   */
  		 24, /*   38         56     8   */
  		 25, /*   39         57     9   */
  		 26, /*   3A         58     :   */
  		 27, /*   3B         59     ;   */
  		 28, /*   3C         60     <   */
  		 29, /*   3D         61     =   */
  		 30, /*   3E         62     >   */
  		 31, /*   3F         63     ?   */
  		 32, /*   40         64     @   */
  		 33, /*   41         65     A   */
  		 34, /*   42         66     B   */
  		 35, /*   43         67     C   */
  		 36, /*   44         68     D   */
  		 37, /*   45         69     E   */
  		 38, /*   46         70     F   */
  		 39, /*   47         71     G   */
  		 40, /*   48         72     H   */
  		 41, /*   49         73     I   */
  		 42, /*   4A         74     J   */
  		 43, /*   4B         75     K   */
  		 44, /*   4C         76     L   */
  		 45, /*   4D         77     M   */
  		 46, /*   4E         78     N   */
  		 47, /*   4F         79     O   */
  		 48, /*   50         80     P   */
  		 49, /*   51         81     Q   */
  		 50, /*   52         82     R   */
  		 51, /*   53         83     S   */
  		 52, /*   54         84     T   */
  		 53, /*   55         85     U   */
  		 54, /*   56         86     V   */
  		 55, /*   57         87     W   */
  		 56, /*   58         88     X   */
  		 57, /*   59         89     Y   */
  		 58, /*   5A         90     Z   */
  		 59, /*   5B         91     [   */
  		 60, /*   5C         92     \   */
  		 61, /*   5D         93     ]   */
  		 62, /*   5E         94     ^   */
  		 63, /*   5F         95     _   */
  		 64, /*   60         96     `   */
  		 65, /*   61         97     a   */
  		 66, /*   62         98     b   */
  		 67, /*   63         99     c   */
  		 68, /*   64        100     d   */
  		 69, /*   65        101     e   */
  		 70, /*   66        102     f   */
  		 71, /*   67        103     g   */
  		 72, /*   68        104     h   */
  		 73, /*   69        105     i   */
  		 74, /*   6A        106     j   */
  		 75, /*   6B        107     k   */
  		 76, /*   6C        108     l   */
  		 77, /*   6D        109     m   */
  		 78, /*   6E        110     n   */
  		 79, /*   6F        111     o   */
  		 80, /*   70        112     p   */
  		 81, /*   71        113     q   */
  		 82, /*   72        114     r   */
  		 83, /*   73        115     s   */
  		 84, /*   74        116     t   */
  		 85, /*   75        117     u   */
  		 86, /*   76        118     v   */
  		 87, /*   77        119     w   */
  		 88, /*   78        120     x   */
  		 89, /*   79        121     y   */
  		 90, /*   7A        122     z   */
  		 91, /*   7B        123     {   */
  		 92, /*   7C        124     |   */
  		 93, /*   7D        125     }   */
  		 94, /*   7E        126     ~   */
  		 95, /*   7F        127        */
  		  0, /*   80        128   ? */
  		  0, /*   81        129   � */
  		  0, /*   82        130   ? */
  		  0, /*   83        131   ? */
  		  0, /*   84        132   ? */
  		  0, /*   85        133   ? */
  		  0, /*   86        134   ? */
  		  0, /*   87        135   ? */
  		  0, /*   88        136   ? */
  		  0, /*   89        137   ? */
  		  0, /*   8A        138   ? */
  		  0, /*   8B        139   ? */
  		  0, /*   8C        140   ? */
  		  0, /*   8D        141   � */
  		  0, /*   8E        142   ? */
  		  0, /*   8F        143   � */
  		  0, /*   90        144   � */
  		  0, /*   91        145   ? */
  		  0, /*   92        146   ? */
  		  0, /*   93        147   ? */
  		  0, /*   94        148   ? */
  		  0, /*   95        149   ? */
  		  0, /*   96        150   ? */
  		  0, /*   97        151   ? */
  		  0, /*   98        152   ? */
  		  0, /*   99        153   ? */
  		  0, /*   9A        154   ? */
  		  0, /*   9B        155   ? */
  		  0, /*   9C        156   ? */
  		  0, /*   9D        157   � */
  		  0, /*   9E        158   ? */
  		  0, /*   9F        159   ? */
  		  0, /*   A0        160   � */
  		  0, /*   A1        161   � */
  		  0, /*   A2        162   � */
  		  0, /*   A3        163   � */
  		  0, /*   A4        164   � */
  		  0, /*   A5        165   � */
  		  0, /*   A6        166   � */
  		  0, /*   A7        167   � */
  		  0, /*   A8        168   � */
  		  0, /*   A9        169   � */
  		  0, /*   AA        170   � */
  		  0, /*   AB        171   � */
  		  0, /*   AC        172   � */
  		  0, /*   AD        173   � */
  		  0, /*   AE        174   � */
  		  0, /*   AF        175   � */
  		  0, /*   B0        176   � */
  		  0, /*   B1        177   � */
  		  0, /*   B2        178   � */
  		  0, /*   B3        179   � */
  		  0, /*   B4        180   � */
  		  0, /*   B5        181   � */
  		  0, /*   B6        182   � */
  		  0, /*   B7        183   � */
  		  0, /*   B8        184   � */
  		  0, /*   B9        185   � */
  		  0, /*   BA        186   � */
  		  0, /*   BB        187   � */
  		  0, /*   BC        188   � */
  		  0, /*   BD        189   � */
  		  0, /*   BE        190   � */
  		  0, /*   BF        191   � */
  		  0, /*   C0        192   � */
  		  0, /*   C1        193   � */
  		  0, /*   C2        194   � */
  		  0, /*   C3        195   � */
  		  0, /*   C4        196   � */
  		  0, /*   C5        197   � */
  		  0, /*   C6        198   � */
  		  0, /*   C7        199   � */
  		  0, /*   C8        200   � */
  		  0, /*   C9        201   � */
  		  0, /*   CA        202   � */
  		  0, /*   CB        203   � */
  		  0, /*   CC        204   � */
  		  0, /*   CD        205   � */
  		  0, /*   CE        206   � */
  		  0, /*   CF        207   � */
  		  0, /*   D0        208   � */
  		  0, /*   D1        209   � */
  		  0, /*   D2        210   � */
  		  0, /*   D3        211   � */
  		  0, /*   D4        212   � */
  		  0, /*   D5        213   � */
  		  0, /*   D6        214   � */
  		  0, /*   D7        215   � */
  		  0, /*   D8        216   � */
  		  0, /*   D9        217   � */
  		  0, /*   DA        218   � */
  		  0, /*   DB        219   � */
  		  0, /*   DC        220   � */
  		  0, /*   DD        221   � */
  		  0, /*   DE        222   � */
  		  0, /*   DF        223   � */
  		  0, /*   E0        224   � */
  		  0, /*   E1        225   � */
  		  0, /*   E2        226   � */
  		  0, /*   E3        227   � */
  		  0, /*   E4        228   � */
  		  0, /*   E5        229   � */
  		  0, /*   E6        230   � */
  		  0, /*   E7        231   � */
  		  0, /*   E8        232   � */
  		  0, /*   E9        233   � */
  		  0, /*   EA        234   � */
  		  0, /*   EB        235   � */
  		  0, /*   EC        236   � */
  		  0, /*   ED        237   � */
  		  0, /*   EE        238   � */
  		  0, /*   EF        239   � */
  		  0, /*   F0        240   � */
  		  0, /*   F1        241   � */
  		  0, /*   F2        242   � */
  		  0, /*   F3        243   � */
  		  0, /*   F4        244   � */
  		  0, /*   F5        245   � */
  		  0, /*   F6        246   � */
  		  0, /*   F7        247   � */
  		  0, /*   F8        248   � */
  		  0, /*   F9        249   � */
  		  0, /*   FA        250   � */
  		  0, /*   FB        251   � */
  		  0, /*   FC        252   � */
  		  0, /*   FD        253   � */
  		  0, /*   FE        254   � */
  		  0, /*   FF        255   � */
};



