/******************************************************************************
 *   nvic.h:  Header file for NXP LPC17xx Family 
 *   Microprocessors
 *
 *   Copyright(C) 2008, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2008.08.21  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/
#ifndef __NVIC_H 
#define __NVIC_H

#include "type.h"

/* NVIC Init Structure definition */
typedef struct
{
  BYTE NVIC_IRQChannel;
  BYTE NVIC_IRQChannelPreemptionPriority;
  BYTE NVIC_IRQChannelSubPriority;
  FunctionalState NVIC_IRQChannelCmd;
  PFV cb;
} NVIC_InitTypeDef;

/* System Handlers -----------------------------------------------------------*/
#define SystemHandler_NMI            (0x00001F) /* NMI Handler */
#define SystemHandler_HardFault      (0x000000) /* Hard Fault Handler */
#define SystemHandler_MemoryManage   (0x043430) /* Memory Manage Handler */
#define SystemHandler_BusFault       (0x547931) /* Bus Fault Handler */
#define SystemHandler_UsageFault     (0x24C232) /* Usage Fault Handler */
#define SystemHandler_SVCall         (0x01FF40) /* SVCall Handler */
#define SystemHandler_DebugMonitor   (0x0A0080) /* Debug Monitor Handler */
#define SystemHandler_PSV            (0x02829C) /* PSV Handler */
#define SystemHandler_SysTick        (0x02C39A) /* SysTick Handler */

/* Vector Table Base ---------------------------------------------------------*/
#define NVIC_VectTab_RAM             (0x10000000)
#define NVIC_VectTab_FLASH           (0x00000000)

/* System Low Power ----------------------------------------------------------*/
#define NVIC_LP_SEVONPEND            (0x10)
#define NVIC_LP_SLEEPDEEP            (0x04)
#define NVIC_LP_SLEEPONEXIT          (0x02)

/* Preemption Priority Group -------------------------------------------------*/
#define NVIC_PriorityGroup_0         (0x700) /* 0 bits for pre-emption priority
                                                5 bits for subpriority */
#define NVIC_PriorityGroup_1         (0x600) /* 1 bits for pre-emption priority
                                                4 bits for subpriority */
#define NVIC_PriorityGroup_2         (0x500) /* 2 bits for pre-emption priority
                                                3 bits for subpriority */
#define NVIC_PriorityGroup_3         (0x400) /* 3 bits for pre-emption priority
                                                2 bits for subpriority */
#define NVIC_PriorityGroup_4         (0x300) /* 4 bits for pre-emption priority
                                                1 bits for subpriority */
#define NVIC_PriorityGroup_5         (0x200) /* 5 bits for pre-emption priority
                                                0 bits for subpriority */

/* Exported functions ------------------------------------------------------- */
void NVIC_DeInit(void);
void NVIC_SCBDeInit(void);
void NVIC_PriorityGroupConfig(DWORD NVIC_PriorityGroup);
void NVIC_Init(NVIC_InitTypeDef* NVIC_InitStruct);
void NVIC_StructInit(NVIC_InitTypeDef* NVIC_InitStruct);
void NVIC_SETPRIMASK(void);
void NVIC_RESETPRIMASK(void);
void NVIC_SETFAULTMASK(void);
void NVIC_RESETFAULTMASK(void);
void NVIC_BASEPRICONFIG(DWORD NewPriority);
DWORD NVIC_GetBASEPRI(void);
WORD NVIC_GetCurrentPendingIRQChannel(void);
ITStatus NVIC_GetIRQChannelPendingBitStatus(BYTE NVIC_IRQChannel);
void NVIC_SetIRQChannelPendingBit(BYTE NVIC_IRQChannel);
void NVIC_ClearIRQChannelPendingBit(BYTE NVIC_IRQChannel);
WORD NVIC_GetCurrentActiveHandler(void);
ITStatus NVIC_GetIRQChannelActiveBitStatus(BYTE NVIC_IRQChannel);
DWORD NVIC_GetCPUID(void);
void NVIC_SetVectorTable(DWORD NVIC_VectTab, DWORD Offset);
void NVIC_GenerateSystemReset(void);
void NVIC_GenerateCoreReset(void);
void NVIC_SystemLPConfig(BYTE LowPowerMode, FunctionalState NewState);
void NVIC_SystemHandlerConfig(DWORD SystemHandler, FunctionalState NewState);
void NVIC_SystemHandlerPriorityConfig(DWORD SystemHandler, BYTE SystemHandlerPreemptionPriority,
                                      BYTE SystemHandlerSubPriority);
ITStatus NVIC_GetSystemHandlerPendingBitStatus(DWORD SystemHandler);
void NVIC_SetSystemHandlerPendingBit(DWORD SystemHandler);
void NVIC_ClearSystemHandlerPendingBit(DWORD SystemHandler);
ITStatus NVIC_GetSystemHandlerActiveBitStatus(DWORD SystemHandler);
DWORD NVIC_GetFaultHandlerSources(DWORD SystemHandler);
DWORD NVIC_GetFaultAddress(DWORD SystemHandler);

#endif /* end __NVIC_H */

/******************************************************************************
**                            End Of File
******************************************************************************/
