/************************************************
***  LPC17xx Ethernet Throughput example  *******
************************************************/

#include "LPC17xx.h"
#include "target.h"
#include "emac.h"
#include "dma.h"
#include "config.h"


char tx_buf[FRAMESIZE];

static unsigned short *txptr;


void assemble_packet(void) {
  int i,j=0;

  tx_buf[0]  = 0xFF;
  tx_buf[1]  = 0xFF;
  tx_buf[2]  = 0xFF;
  tx_buf[3]  = 0xFF;
  tx_buf[4]  = 0xFF;
  tx_buf[5]  = 0xFF;
  tx_buf[6]  = 0x00;
  tx_buf[7]  = 0x01;
  tx_buf[8]  = 0x02;
  tx_buf[9]  = 0x03;
  tx_buf[10] = 0x04;
  tx_buf[11] = 0x05;

  tx_buf[12] = 0x08;
  tx_buf[13] = 0x00;

  tx_buf[14] = 0x00;
  tx_buf[15] = 0x00;

  for (i=16;i<FRAMESIZE;i++) {
     tx_buf[i] = j;
	 j++;
	 if (j == 16)
	   j = 0;
  }
}

void WriteData_EMAC(unsigned short Data)
{
  *txptr++ = Data;
}


void FillDataBuffer(void *Source, unsigned int Size)
{

  unsigned short * piSource;
  unsigned int bytes;

  piSource = Source;
  Size = (Size + 1) & 0xFFFE;    // round Size up to next even number
  bytes = Size;
  while (bytes > 0) {
    WriteData_EMAC(*piSource++);
    bytes -= 2;
  }
}

void FillOneDataBuffer(void *Source, unsigned int Size)
{
  unsigned int idx;
  unsigned int save_size = Size;

  idx = TxProduceIndex;
  txptr = (unsigned short *)TX_DESC_PACKET(idx);
  TX_DESC_CTRL(idx) = save_size | TCTRL_LAST | TCTRL_INT;
  FillDataBuffer(Source,Size);
}

void FillAllDataBuffers(void *Source, unsigned int Size)
{
  unsigned int idx;
  unsigned int save_size = Size;

  for (idx=0;idx<NUM_TX_FRAG;idx++) {
	txptr = (unsigned short *)TX_DESC_PACKET(idx);
	TX_DESC_CTRL(idx) = save_size | TCTRL_LAST | TCTRL_INT;
	FillDataBuffer(Source,Size);
  }
}

void IncrementTxDescriptor(void) {
  unsigned int idx;

  idx = TxProduceIndex;
  if (++idx == NUM_TX_FRAG) idx = 0;
  while( idx == TxConsumeIndex );			// if (TxProduceIndex = TxConsumeIndex -1) then TxDescriptors are full	  
  TxProduceIndex = idx;
}


int main (void)
{
  int i=1;
#if SCENARIO == 2	
  INT_32 dmach;
  unsigned int idx;
#endif

  TargetResetInit();
  Init_EMAC(); 
  for(i=0;i<1000000;i++);

  FIO0DIR = 0x01;   // P0.0 as Output
  FIO0CLR = 0x01;

  assemble_packet();

#if SCENARIO == 0		// Scenario 1 
  FillAllDataBuffers(&tx_buf[0], FRAMESIZE-1);	 
  for(i=0;i<2000000;i++);
  FIO0SET = 0x01;
  for (i=0;i<NUMBER_FRAMES;i++) {
    IncrementTxDescriptor();   
  }
#endif

#if SCENARIO == 1		// Scenario 2
  for(i=0;i<2000000;i++);
  FIO0SET = 0x01;
  for (i=0;i<NUMBER_FRAMES;i++) {
    FillOneDataBuffer(&tx_buf[0], FRAMESIZE-1);	
    IncrementTxDescriptor();   
  }
#endif


#if SCENARIO == 2		// Scenario 3
  /* Initialize DMA */
  dma_init();
  dmach = dma_alloc_channel(0, NULL);
  if (dmach < 0) 
  {
    /* "Error allocating DMA channel */
	while(1);
  }
  for(i=0;i<2000000;i++);
  FIO0SET = 0x01;
  for (i=0;i<NUMBER_FRAMES;i++) {
    idx  = TxProduceIndex;
    txptr = (unsigned short *)TX_DESC_PACKET(idx);
    TX_DESC_CTRL(idx) = (FRAMESIZE-1) | TCTRL_LAST | TCTRL_INT;
    dma_start_m2m(dmach, (void *)(&tx_buf[0]),(void *) (txptr), NULL, FRAMESIZE);

    while((DMAC->raw_tc_stat & _BIT(dmach)) == 0);
	DMAC->int_tc_clear = _BIT(dmach);  
  
    idx = TxProduceIndex;
    if (++idx == NUM_TX_FRAG) idx = 0;
	while( idx == TxConsumeIndex );
    TxProduceIndex = idx;
  }
#endif
  while( TxProduceIndex != TxConsumeIndex );
  FIO0CLR = 0x01;
	
  while(1); 
}
