#include "EMAC.h"
#include "LPC17xx.h"

void write_PHY (int PhyReg, int Value)
{
  unsigned int tout;

  MADR = DP83848C_DEF_ADR | PhyReg;
  MWTD = Value;
  /* Wait utill operation completed */
  tout = 0;
  for (tout = 0; tout < MII_WR_TOUT; tout++) {
    if ((MIND & MIND_BUSY) == 0) {
      break;
    }
  }
}


unsigned short read_PHY (unsigned char PhyReg) 
{
  unsigned int tout;

  MADR = DP83848C_DEF_ADR | PhyReg;
  MCMD = MCMD_READ;
  /* Wait until operation completed */
  tout = 0;
  for (tout = 0; tout < MII_RD_TOUT; tout++) {
    if ((MIND & MIND_BUSY) == 0) {
      break;
    }
  }
  MCMD = 0;
  return (MRDD);
}



void rx_descr_init (void)
{
  unsigned int i;

  for (i = 0; i < NUM_RX_FRAG; i++) {
    RX_DESC_PACKET(i)  = RX_BUF(i);
    RX_DESC_CTRL(i)    = RCTRL_INT | (ETH_FRAG_SIZE-1);
    RX_STAT_INFO(i)    = 0;
    RX_STAT_HASHCRC(i) = 0;
  }

  /* Set EMAC Receive Descriptor Registers. */
  RxDescriptor    = RX_DESC_BASE;
  RxStatus        = RX_STAT_BASE;
  RxDescriptorNumber = NUM_RX_FRAG-1;

  /* Rx Descriptors Point to 0 */
  RxConsumeIndex  = 0;
}



void tx_descr_init (void) {
  unsigned int i;

  for (i = 0; i < NUM_TX_FRAG; i++) {
    TX_DESC_PACKET(i) = TX_BUF(i);
    TX_DESC_CTRL(i)   = 0;
    TX_STAT_INFO(i)   = 0;
  }

  /* Set EMAC Transmit Descriptor Registers. */
  TxDescriptor    = TX_DESC_BASE;
  TxStatus        = TX_STAT_BASE;
  TxDescriptorNumber = NUM_TX_FRAG-1;

  /* Tx Descriptors Point to 0 */
  TxProduceIndex  = 0;
}




void Init_EMAC(void)
{

  unsigned int regv,tout,id1,id2;

   
   /* Power Up the EMAC controller. */
  PCONP |= 0x40000000;
 
  PINSEL2 = 0x50150105;
  PINSEL3 = (PINSEL3 & ~0x0000000F) | 0x00000005;

  /* Reset all EMAC internal modules. */
  MAC1 = MAC1_RES_TX | MAC1_RES_MCS_TX | MAC1_RES_RX | MAC1_RES_MCS_RX |
             MAC1_SIM_RES | MAC1_SOFT_RES;
  Command = CR_REG_RES | CR_TX_RES | CR_RX_RES | CR_PASS_RUNT_FRM;
  
  /* A short delay after reset. */
  for (tout = 100; tout; tout--);

  /* Initialize MAC control registers. */
  MAC1 = MAC1_PASS_ALL;
  MAC2 = MAC2_CRC_EN | MAC2_PAD_EN;
 
  MAXF = ETH_MAX_FLEN;
  CLRT = CLRT_DEF;
  IPGR = IPGR_DEF;

  /* Enable Reduced MII interface. */
  Command = CR_RMII | CR_PASS_RUNT_FRM;

  /* Put the DP83848C in reset mode */
  write_PHY (PHY_REG_BMCR, 0x8000);

  /* Wait for hardware reset to end. */
  for (tout = 0; tout < 0x100000; tout++) {
    regv = read_PHY (PHY_REG_BMCR);
    if (!(regv & 0x8000)) {
      /* Reset complete */
      break;
    }
  }

  /* Check if this is a DP83848C PHY. */
  id1 = read_PHY (PHY_REG_IDR1);
  id2 = read_PHY (PHY_REG_IDR2);
  if (((id1 << 16) | (id2 & 0xFFF0)) == DP83848C_ID) {
    /* Configure the PHY device */

    /* Use autonegotiation about the link speed. */
    write_PHY (PHY_REG_BMCR, PHY_AUTO_NEG);
    /* Wait to complete Auto_Negotiation. */
    for (tout = 0; tout < 0x100000; tout++) {
      regv = read_PHY (PHY_REG_BMSR);
      if (regv & 0x0020) {
        /* Autonegotiation Complete. */
        break;
      }
    }
  }

  /* Check the link status. */
  for (tout = 0; tout < 0x10000; tout++) {
    regv = read_PHY (PHY_REG_STS);
    if (regv & 0x0001) {
      /* Link is on. */
      break;
    }
  }

  /* Configure Full/Half Duplex mode. */
  if (regv & 0x0004) {
    /* Full duplex is enabled. */
    MAC2    |= MAC2_FULL_DUP;
    Command |= CR_FULL_DUP;
    IPGT     = IPGT_FULL_DUP;
  }
  else {
    /* Half duplex mode. */
    IPGT = IPGT_HALF_DUP;
  }

  /* Configure 100MBit/10MBit mode. */
  if (regv & 0x0002) {
    /* 10MBit mode. */
    SUPP = 0;
  }
  else {
    /* 100MBit mode. */
    SUPP = SUPP_SPEED;
  }

  /* Set the Ethernet MAC Address registers */
  SA0 = (MYMAC_1 << 8) | MYMAC_2;
  SA1 = (MYMAC_3 << 8) | MYMAC_4;
  SA2 = (MYMAC_5 << 8) | MYMAC_6;

  /* Initialize Tx and Rx DMA Descriptors */
  rx_descr_init ();
  tx_descr_init ();

  /* Receive Broadcast and Perfect Match Packets */
  RxFilterCtrl = RFC_BCAST_EN | RFC_PERFECT_EN;					 

  /* Enable EMAC interrupts. */
  IntEnable = INT_RX_DONE | INT_TX_DONE;

  /* Reset all interrupts */
  IntClear  = 0xFFFF;

  /* Enable receive and transmit mode of MAC Ethernet core */
  Command  |= (CR_RX_EN | CR_TX_EN);
  MAC1     |= MAC1_REC_EN;
 
}

