/******************************************************************************
 *   systick.h:  Header file for NXP LPC17xx Family 
 *   Microprocessors
 *
 *   Copyright(C) 2008, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2008.08.21  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/
#ifndef __SYSTICK_H 
#define __SYSTICK_H

#include "type.h"

/* SysTick clock source */
#define SysTick_CLKSource_STCLK        (0xFFFFFFFB)
#define SysTick_CLKSource_CCLK         (0x00000004)

/* SysTick counter state */
#define SysTick_Counter_Disable        (0xFFFFFFFE)
#define SysTick_Counter_Enable         (0x00000001)
#define SysTick_Counter_Clear          (0x00000000)

/* CTRL TICKINT Mask */
#define CTRL_TICKINT_Set               (0x00000002)
#define CTRL_TICKINT_Reset             (0xFFFFFFFD)

/* SysTick Flag */
#define SysTick_FLAG_COUNT             (0x30)
#define SysTick_FLAG_SKEW              (0x5E)
#define SysTick_FLAG_NOREF             (0x5F)

/* Exported functions ------------------------------------------------------- */
void SysTickHandler(void);
void delaySysTick(DWORD tick);
void SysTick_CLKSourceConfig(DWORD SysTick_CLKSource);
void SysTick_SetReload(DWORD Reload);
void SysTick_CounterCmd(DWORD SysTick_Counter);
void SysTick_ITConfig(FunctionalState NewState);
DWORD SysTick_GetCounter(void);
FlagStatus SysTick_GetFlagStatus(BYTE SysTick_FLAG);

#endif /* end __SYSTICK_H */

/******************************************************************************
**                            End Of File
******************************************************************************/
