
/*************************************************************************
 * Function Name: main
 * Parameters: none
 *
 * Return: none
 *
 * Description: main
 *
 *************************************************************************/
#include "LPC17xx.h"
#include "lpc17xx_nvic.h"
#include "LPC17xx_gpio.h"

#include "IEC60335.h"

extern IEC60335_CPUreg_struct CPUregTestPOST_struct;
extern IEC60335_CPUreg_struct CPUregTestBIST_struct;

/* IEC60335 Flash test signature */
FlashSign_t signature = {0,0,0,0};
#define FLASH_TEST_RANGE 0x400*16

volatile unsigned long test = 0;
volatile unsigned long SysTickCnt;      /* SysTick Counter                    */


void SysTick_Handler (void) {           /* SysTick Interrupt Handler (1ms)    */

	SysTickCnt++;
}

void Delay (unsigned long tick) {       /* Delay Function                     */
  unsigned long systickcnt;

  systickcnt = SysTickCnt;
  while ((SysTickCnt - systickcnt) < tick);
}


int main(void)
{
    UINT32 delay = 500;  
  
    /* Do the IEC60335 CPU register tests */
    _CPUregTestPOST();
    if (CPUregTestPOST_struct.testPassed == IEC60335_testFailed)
    {
        /* POST CPU register test failed */
        while (1);
    }
    
    //	/* Do the IEC60335 POST RAM test */
    //	if (IEC60335_RAMtest_POST() == IEC60335_testFailed);
    //	{
    //		while(1);
    //	}
    
    /* Do the IEC60335 POST FLASH test */
    if (IEC60335_FLASHtest_POST (0x0007FFE0) == IEC60335_testFailed)
    {
    /* For testing while is disabled */
    //		while (1);
    }
  
    /* Initialize the clocks */
    SystemInit ();
    
    /* Expansion statement ----------------------------------------------------- */
    // DeInit NVIC and SCBNVIC
    NVIC_DeInit();
    NVIC_SCBDeInit();

    /* Configure the NVIC Preemption Priority Bits:
     * two (2) bits of preemption priority, six (6) bits of sub-priority.
     * Since the Number of Bits used for Priority Levels is five (5), so the
     * actual bit number of sub-priority is three (3)
     */
    NVIC_SetPriorityGrouping(0x05);

    //  Set Vector table offset value
    #if (__RAM_MODE__==1)
    NVIC_SetVTOR(0x10000000);
    #else
    NVIC_SetVTOR(0x00000000);
    #endif
    /* End of Expansion statement ------------------------------------------------ */
  
    /* IAR enable interrupt call */
    __enable_interrupt();

    SysTick_Config(SystemFrequency/1000 - 1); /* Generate interrupt each 1 ms   */
    
    FIO_ByteSetDir(2, 0, 7<<4, 1);				/* LEDs defined as Output             */
    
    /* Generate the reference signature */
    StartSoftSignatureGen(0x00000000, FLASH_TEST_RANGE, &signature);
  
    
    while(1)
    {
        Delay(500);
        FIO_ByteSetValue(2, 0, 1<<6);
        Delay(500);
        FIO_ByteClearValue(2, 0, 1<<6);

        FIO_ByteSetValue(2, 0, 1<<5);
        /* Do the IEC60335 BIST CPU register tests */
    	  IEC60335_CPUregTest_BIST();
        if (CPUregTestBIST_struct.testPassed == IEC60335_testFailed)
        {
        	while (1);
        }

        FIO_ByteClearValue(2, 0, 1<<5);
        /* Do the IEC60335 BIST RAM test */
        if (IEC60335_RAMtest_BIST(0x10007000, 0x400) == IEC60335_testFailed)
        {
        	while (1);
        }

        FIO_ByteSetValue(2, 0, 1<<5);
        /* Do the IEC60335 FLASH test */
        if (IEC60335_FLASHtest_BIST (0x00000000, FLASH_TEST_RANGE, &signature, FLASH_HARD_SIGN) == IEC60335_testFailed)
        {
        	while (1);
        }
        FIO_ByteClearValue(2, 0, 1<<5); 
      
      
    }
}
