#********************************************************************
# * Project:    Cortex-M3 Template
# * File:       cortexm3_macro.s
# *
# * System:     Cortex M3
# * Compiler:   GNU GCC 
# *
# * Date:       2009-05-12
# * Author:     Application@Hitex.de
# *
# * Rights:     Hitex Development Tools GmbH
# *             Greschbachstr. 12
# *             D-76229 Karlsruhe
# ********************************************************************
# * Description:
# *
# * This is a small implementation of different features
# * The application runs in Thumb mode with high optimization level.
# *
# ********************************************************************
# * History:
# *
# *    Revision 1.2    2008/01/23      Gn  Updated for GCC
# *
# ********************************************************************
# * This is a preliminary version.
# *
# * WARRANTY:  HITEX warrants that the media on which the SOFTWARE is
# * furnished is free from defects in materials and workmanship under
# * normal use and service for a period of ninety (90) days. HITEX entire
# * liability and your exclusive remedy shall be the replacement of the
# * SOFTWARE if the media is defective. This Warranty is void if failure
# * of the media resulted from unauthorized modification, accident, abuse,
# * or misapplication.
# *
# * DISCLAIMER:  OTHER THAN THE ABOVE WARRANTY, THE SOFTWARE IS FURNISHED
# * "AS IS" WITHOUT WARRANTY OF ANY KIND. HITEX DISCLAIMS ALL OTHER WARRANTIES,
# * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO IMPLIED WARRANTIES
# * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
# *
# * NEITHER HITEX NOR ITS AFFILIATES SHALL BE LIABLE FOR ANY DAMAGES ARISING
# * OUT OF THE USE OF OR INABILITY TO USE THE SOFTWARE, INCLUDING DAMAGES FOR
# * LOSS OF PROFITS, BUSINESS INTERRUPTION, OR ANY SPECIAL, INCIDENTAL, INDIRECT
# * OR CONSEQUENTIAL DAMAGES EVEN IF HITEX HAS BEEN ADVISED OF THE POSSIBILITY
# * OF SUCH DAMAGES.
# ********************************************************************


# ---------------------------------------------
# mode of asembly
# ---------------------------------------------
      .syntax unified
      .thumb
      .arch armv7m

# ---------------------------------------------
# allocation
# ---------------------------------------------
      .text

# ---------------------------------------------
# macro for WFI instruction
# ---------------------------------------------
   .global __WFI
   .thumb_func
__WFI:
   wfi
   bx    r14
# ---------------------------------------------
# macro for WFE instruction
# ---------------------------------------------
   .global __WFE
   .thumb_func
__WFE:
   wfe
   bx    lr
# ---------------------------------------------
# macro for __SEV instruction
# ---------------------------------------------

   .global __SEV
   .thumb_func
__SEV:
   sev
   bx      lr

# ---------------------------------------------
# macro for __SETPRIMASK instruction
# ---------------------------------------------
   .global __SETPRIMASK
   .thumb_func
__SETPRIMASK:
   cpsid   i
   bx      lr

# ---------------------------------------------
# macro for __RESETPRIMASK instruction
# ---------------------------------------------
   .global __RESETPRIMASK
   .thumb_func
__RESETPRIMASK:
   cpsie   i
   bx      lr

# ---------------------------------------------
# macro for __SETFAULTMASK instruction
# ---------------------------------------------
   .global __SETFAULTMASK
   .thumb_func
__SETFAULTMASK:
   cpsid   f
   bx      lr

# ---------------------------------------------
# macro for __RESETFAULTMASK instruction
# ---------------------------------------------
   .global __RESETFAULTMASK
   .thumb_func
__RESETFAULTMASK:
   cpsie   f
   bx      lr

# ---------------------------------------------
# macro for __BASEPRICONFIG instruction
# ---------------------------------------------
   .global __BASEPRICONFIG
   .thumb_func
__BASEPRICONFIG:
   msr basepri, r0
   bx      lr

# ---------------------------------------------
# macro for __GetBASEPRI instruction
# ---------------------------------------------
   .global __GetBASEPRI
   .thumb_func
__GetBASEPRI:
   mrs r4, basepri_max
   bx      lr

# ---------------------------------------------
# Macro Name:         __Output
# Description:           Assembler function to write a debug out to a
#                        Stimulus Port.
# Input:                 r0: character
#                        r1: Address of Stimulus Register
# Return:                r0 : Base Priority value
# ---------------------------------------------
   .global __Output
   .thumb_func
__Output:
   push {lr}
retry:
   LDR       R2, [R1]
   CMP       R2,#0
   BEQ       retry
   STRB      R0,[R1]

   LDR       lr, [sp] ,#0x4
   BX        lr

   .end
