/**
 * @file	IEC60335_B_FLASHtest.c
 * @purpose
 * @brief
 * @version
 * @date	10-sep-2009
 * @author	nlv15840
*/
/*----------------------------------------------------------------------------
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/

#include "LPC17xx.h"
#include "IEC60335.h"

FlashSign_t IEC60335_Flash_Sign_POST,
			IEC60335_Flash_Sign_BIST;

__attribute__ ((section(".MISR_area")))
static UINT32 TESTSIGN[4] = {	0x4e672fd9,
								0x2f08cec7,
								0x197932b1,
								0x9ac17416};

void StartHardSignatureGen (UINT32 startAddr, UINT32 length, FlashSign_t *pResultSign)
{
	/* align flash address to refer the flash word in the array*/
    startAddr = (startAddr >> 4) & 0x0001ffff;
    length  = 	((startAddr + length) >> 4)  & 0x0001ffff;

    /* write start address of the flash contents to the register*/
    LPC_FMC->FMSSTART = startAddr;

    /* write stop address of the flash contents to the register, start generating the signature*/
    LPC_FMC->FMSSTOP = length | MISR_START;

    /* wait for signature to be generated */
    while ((LPC_FMC->STATUS & EOM) != EOM);
    LPC_FMC->CLR_STATUS = EOM;

	/* Store the signatures in the structure */
    pResultSign->word0 = LPC_FMC->FMSW0;
    pResultSign->word1 = LPC_FMC->FMSW1;
    pResultSign->word2 = LPC_FMC->FMSW2;
    pResultSign->word3 = LPC_FMC->FMSW3;

    return;
}

void StartSoftSignatureGen (UINT32 startAddr, UINT32 length, FlashSign_t *pResultSign)
{
	FlashSign_t flashWord;
	FlashSign_t refSignature = {0,0,0,0};
	FlashSign_t nextSign;

	UINT32 		*PageAddr = 0,
				i;

	PageAddr = (UINT32 *)((UINT32)startAddr);

	for ( i = 0; i <= (length>>4); i++ )
	{
		flashWord.word0 = *PageAddr;
		PageAddr++;
		flashWord.word1 = *PageAddr;
		PageAddr++;
		flashWord.word2 = *PageAddr;
		PageAddr++;
		flashWord.word3 = *PageAddr;
		PageAddr++;

	    /* update 128 bit signature */
	    nextSign.word0 = flashWord.word0 ^ refSignature.word0>>1 ^ refSignature.word1<<31;
	    nextSign.word1 = flashWord.word1 ^ refSignature.word1>>1 ^ refSignature.word2<<31;
	    nextSign.word2 = flashWord.word2 ^ refSignature.word2>>1 ^ refSignature.word3<<31;
	    nextSign.word3 = flashWord.word3 ^ refSignature.word3>>1 ^
	                     ( refSignature.word0 & 1<<29 )<<2 ^
	                     ( refSignature.word0 & 1<<27 )<<4 ^
	                     ( refSignature.word0 & 1<<2 )<<29 ^
	                     ( refSignature.word0 & 1<<0 )<<31;

	    /* point to the calculated value */
	    refSignature.word0 = nextSign.word0;
	    refSignature.word1 = nextSign.word1;
	    refSignature.word2 = nextSign.word2;
	    refSignature.word3 = nextSign.word3;
	}

	/* Copy the reference signature to the result pointer */
	*pResultSign = refSignature;

}

type_testResult IEC60335_FLASHtest_POST (UINT32 size)
{
	FlashSign_t ResultSign, TestSign;

	/* Do the POST signature generation according to the
	 * various flash sizes
	 */
	StartHardSignatureGen (0x00000000, size, &ResultSign);

	/* Fetch the pre-calculated signature */
	TestSign.word0 = TESTSIGN[0];//_W0;
	TestSign.word1 = TESTSIGN[1];//_W1;
	TestSign.word2 = TESTSIGN[2];//_W2;
	TestSign.word3 = TESTSIGN[3];//_W3;

	/* Test the generated signature */
	if (IEC60335_testSignatures(&ResultSign, &TestSign) == IEC60335_testFailed)
		return (IEC60335_testFailed);

	/* Copy to Global IEC60335 Flash test structure */
	IEC60335_Flash_Sign_POST.word0 = ResultSign.word0;
	IEC60335_Flash_Sign_POST.word1 = ResultSign.word1;
	IEC60335_Flash_Sign_POST.word2 = ResultSign.word2;
	IEC60335_Flash_Sign_POST.word3 = ResultSign.word3;

	return (IEC60335_testPassed);
}

type_testResult IEC60335_FLASHtest_BIST (UINT32 startAddr, UINT32 length, FlashSign_t *pTestSign, UINT8 selectHS)
{
	FlashSign_t ResultSign = {0,0,0,0};

	/* Select hardware or software signature generation */
	switch (selectHS)
	{
		case FLASH_HARD_SIGN:
			/* Do a hardware signature generation */
			StartHardSignatureGen (startAddr, length, &ResultSign);

			break;
		case FLASH_SOFT_SIGN:
			/* Do a hardware signature generation */
			StartSoftSignatureGen (startAddr, length, &ResultSign);

			break;
		default:
			/* If not hard or soft test return Fail */
			return (IEC60335_testFailed);
			break;
	}

	/* Test the result signature against the test signature */
	if (IEC60335_testSignatures(&ResultSign, pTestSign) == IEC60335_testFailed)
		return (IEC60335_testFailed);

	/* Copy to Global IEC60335 structure */
	IEC60335_Flash_Sign_BIST.word0 = ResultSign.word0;
	IEC60335_Flash_Sign_BIST.word1 = ResultSign.word1;
	IEC60335_Flash_Sign_BIST.word2 = ResultSign.word2;
	IEC60335_Flash_Sign_BIST.word3 = ResultSign.word3;

	return (IEC60335_testPassed);
}

type_testResult IEC60335_testSignatures (FlashSign_t *sign1, FlashSign_t *sign2)
{
	/* Test the signatures to the expected value */
	if (sign1->word0 != sign2->word0) return (IEC60335_testFailed);
	if (sign1->word1 != sign2->word1) return (IEC60335_testFailed);
	if (sign1->word2 != sign2->word2) return (IEC60335_testFailed);
	if (sign1->word3 != sign2->word3) return (IEC60335_testFailed);

	/* Return a Flash test Pass */
	return (IEC60335_testPassed);
}

