/****************************************************************************

      Project     Template
      Autor:      Hitex/We/2009-12-05
      Company:    Hitex Development Tools GmbH
      Filename:   main.ld
      

***************************************************************************/

SEARCH_DIR( "$(ToolDir)\..\arm-hitex-elf\lib\thumb2" )
/* Path setting depends on the gnu compiler version */
/* Adjust the path here to the used version as necessary */
SEARCH_DIR("$(ToolDir)\..\lib\gcc\arm-hitex-elf\4.3.0\thumb\thumb2" )
SEARCH_DIR("$(ToolDir)\..\lib\gcc\arm-hitex-elf\4.3.1\thumb\thumb2" )
SEARCH_DIR("$(ToolDir)\..\lib\gcc\arm-hitex-elf\4.3.3\thumb\thumb2" )
SEARCH_DIR("$(ToolDir)\..\lib\gcc\arm-hitex-elf\4.4.0\thumb2" )
SEARCH_DIR("$(ToolDir)\..\lib\gcc\arm-hitex-elf\$(GNU_CORTEX_VERSION)\thumb2" )

INPUT (
   /* HiTOP will automatically put in here all object files to be linked.
      Leave this unchanged!                                               */
   $(LinkObjects)
)

/* Target Specific Parameters */

MEMORY
{
   FLASH (rx) : ORIGIN = 0x00000000, LENGTH = (0x80000 - 16)
   MISR (rx) : ORIGIN = 0x0007FFF0, LENGTH = 16
   SRAM  (rwx) : ORIGIN = 0x10000000, LENGTH = 0x8000
}

/* Layout Information */
/* Section Definitions */
SECTIONS
{

   .text :
   {
      KEEP(*(.vectors .vector.*))	  
   . = ALIGN(0x300);

	  *(.IEC60335_B_behindVectors)

      __startup_code__ = .;
            $(TargetDir)startup.o (.text)         /* Startup code */
      __startup_code_end__ = .;

	  _IEC60335_code_ = .;
	  *(.IEC60335_code)
	  _IEC60335_code_end_ = .;

	  *(.IEC60335_B_beforeText)

      *(.text .text.*)

	  *(.IEC60335_B_behindText)

      *(.gnu.linkonce.t.*)
      *(.glue_7)
      *(.glue_7t)
      *(.gcc_except_table)
      . = ALIGN(4);
      *(.rodata .rodata*)
      *(.gnu.linkonce.r.*)
	  *(.IEC60335_B_lastFashSection)
	  
	  *(.eh_frame)
      . = ALIGN(4);
      _etext = .;
   } > FLASH

   .data : AT (_etext)
   {
      _data = .;
      *(vtable vtable.*)
	  *(.IEC60335_B_beforeRAMcode)
	  *(.RAMcode)
	  *(.IEC60335_B_behindRAMcode)
      *(.data .data.*)
      *(.gnu.linkonce.d*)
      . = ALIGN(4);
      _edata = . ;
	  /* HEAP!!! */
	  . = . + 0x2000;		/* reserved  for heap */
      . = ALIGN(4);
      *(.stack .stack.*)
      . = ALIGN(4);
	  _stacktop = 0x6000-4; /* Top of Stack */
   } > SRAM

   /* .bss section which is used for uninitialized data */
   .bss (NOLOAD) :
   {
      _bss = . ;
      *(.bss .bss.*)
      *(.gnu.linkonce.b*)
      *(COMMON)
      . = ALIGN(4);
      _ebss = . ;
   } > SRAM

	.MISR_area :
	{
		*(.MISR_area)
	} > MISR

   . = ALIGN(4);
   _end = . ;
   PROVIDE (end = .);

   /* Stabs debugging sections.  */
      .stab          0 : { *(.stab) }
      .stabstr       0 : { *(.stabstr) }
      .stab.excl     0 : { *(.stab.excl) }
      .stab.exclstr  0 : { *(.stab.exclstr) }
      .stab.index    0 : { *(.stab.index) }
      .stab.indexstr 0 : { *(.stab.indexstr) }
      .comment       0 : { *(.comment) }
   /* DWARF debug sections.
      Symbols in the DWARF debugging sections are relative to the beginning
      of the section so we begin them at 0.  */
   /* DWARF 1 */
      .debug          0 : { *(.debug) }
      .line           0 : { *(.line) }
   /* GNU DWARF 1 extensions */
      .debug_srcinfo  0 : { *(.debug_srcinfo) }
      .debug_sfnames  0 : { *(.debug_sfnames) }
   /* DWARF 1.1 and DWARF 2 */
      .debug_aranges  0 : { *(.debug_aranges) }
      .debug_pubnames 0 : { *(.debug_pubnames) }
   /* DWARF 2 */
      .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }
      .debug_abbrev   0 : { *(.debug_abbrev) }
      .debug_line     0 : { *(.debug_line) }
      .debug_frame    0 : { *(.debug_frame) }
      .debug_str      0 : { *(.debug_str) }
      .debug_loc      0 : { *(.debug_loc) }
      .debug_macinfo  0 : { *(.debug_macinfo) }
   /* SGI/MIPS DWARF 2 extensions */
      .debug_weaknames 0 : { *(.debug_weaknames) }
      .debug_funcnames 0 : { *(.debug_funcnames) }
      .debug_typenames 0 : { *(.debug_typenames) }
      .debug_varnames  0 : { *(.debug_varnames) }
}
