//#include "IEC60335_ErrorCodes.h"
#include "IEC60335.h"

/*! \brief Error log management type.

	Only used intern.
*/
typedef struct tag_ErrorLog
{
	UINT32 *pLogBuffer;
	UINT32 length;

	UINT32 idx;
	UINT32 count;
} type_ErrorLog;

BOOL isInitialised = FALSE; /*!< Internally used to prevent un-initialised usage */

type_ErrorLog errorLog = {NULL, NULL, NULL, NULL};

/*! \param pLogBuffer The pointer to the logging Buffer. It has to be a UINT32 array.
	\param length Size of the error logging buffer. But, not in bytes, array size!

	\attention The error logging mechanism is blocked until this function was called.
 */
void IEC60335_initErrorLog(UINT32 *pLogBuffer, UINT32 length)
{
	errorLog.pLogBuffer = pLogBuffer;
	errorLog.length = length;

	errorLog.idx = 0;
	errorLog.count = 0;

	isInitialised = TRUE;
}

/*! \param EC Inserts an error identifier into the Log, if Logging is enabled.
	\see enum tag_ErrorCodes

	\return This function always returns \a IEC60335_testFailed. This eases the usage of checking by macro for example.
	\see enum tag_testResult
 */
type_testResult IEC60335_notifyErrorCode(type_ErrorCode EC)
{
	type_testResult Result = IEC60335_testFailed;
	if(isInitialised)
	{
		if(EC != IEC60335_noError)
		{
			errorLog.pLogBuffer[errorLog.idx++] = EC;

			if(errorLog.idx == errorLog.length)
				errorLog.idx = 0;			//Ringbuffer

			errorLog.count++;
		}
		else
			Result = IEC60335_testPassed;
	}

	return Result;
}

/*!
	\return The last errorcode
	\see enum tag_ErrorCodes
 */
type_ErrorCode IEC60335_getLastErrorCode(void)
{
	type_ErrorCode Result = IEC60335_noError;

	if(isInitialised)
	{
		if(errorLog.count > 0)
		{
			if(errorLog.idx == 0)
				Result = errorLog.pLogBuffer[(errorLog.length - 1)];
			else
				Result = errorLog.pLogBuffer[(errorLog.idx - 1)];
		}
	}

	return Result;
}
