//#include "IEC60335_B_Interrupts.h"
#include "IEC60335.h"


/*!
	The interrupt check has to be called in fixed equidistant times. You must estimate how many times the
	interrupt will occur within this known time slice.

	\param *pIRQ Pointer to the interrupt test structure.
	\param lowerBound Estimated minimum count of occured interrupts. (Don't take respect to the individualValue).
	\param upperBound Estimated maximum count of occured interrupts. (Don't take respect to the individualValue).
	\param individualValue The internally used individual up-counting value.

	\attention Ensure to place the function call #IEC60335_InterruptOcurred into the corresponding
	interrupt service handler!
*/
void IEC60335_InitInterruptTest(type_InterruptTest *pIRQ, UINT32 lowerBound, UINT32 upperBound, UINT32 individualValue)
{
	pIRQ->Count = 0;

	pIRQ->lower = lowerBound;
	pIRQ->upper = upperBound;

	pIRQ->individualValue = individualValue;
}

/*!
	This function must be called from any interrupt service handler which has to be tested.

	\param *pIRQ Pointer to the interrupt test structure.
*/
void IEC60335_InterruptOcurred(type_InterruptTest *pIRQ)
{
	pIRQ->Count += pIRQ->individualValue;
}

/*!
	The interrupt check routine must be called once in known equidistant times.

	\attention	Prevent this function to be disturbed by interrupts. You can either call it insde of an interrupt service handler,
	or disable interrupts globally, but this is not recommended.

	\param *pIRQ Pointer to the interrupt test structure.
	\return Tells if passed or failed. See \link #tag_testResult type_testResult \endlink.
*/
type_testResult IEC60335_InterruptCheck(type_InterruptTest *pIRQ)
{
	type_testResult Result;

	Result = ifIsInRange(pIRQ->lower*pIRQ->individualValue,pIRQ->Count,pIRQ->upper*pIRQ->individualValue) ?
					(IEC60335_testPassed) :
					IEC60335_notifyErrorCode(IEC60335_InterruptFailed);
	pIRQ->Count = 0;

	return Result;
}
