* TITLE TSSOP8
* SPICE format. The pins chosen are shown by the inductor and resistor names.
* L7 or R7 shows that pin 7 was chosen.  Internal subcircuit nodes are
* ordered in an IN/OUT format.  1 is the board end of the first chosen pin, 
* 2 is its die end. 3 is the board end of the 2nd chosen pin.  Etc.
*
.SUBCKT pk8 1 3 5 7  9 11 13 15
+           2 4 6 8 10 12 14 16
R1  1 1001  6.28E-02
R2  3 1003  4.72E-02
R3  5 1005  4.65E-02
R4  7 1007  6.15E-02
R5  9 1009  6.22E-02
R6 11 1011  4.69E-02
R7 13 1013  4.67E-02
R8 15 1015  6.18E-02

L1 1001  2  1.584E-09
L2 1003  4  1.312E-09
L3 1005  6  1.251E-09
L4 1007  8  1.472E-09
L5 1009 10  1.484E-09
L6 1011 12  1.256E-09
L7 1013 14  1.304E-09
L8 1015 16  1.527E-09
.ENDS pk8

* TITLE TSSOP14
* SPICE format. The pins chosen are shown by the inductor and resistor names.
* L7 or R7 shows that pin 7 was chosen.  Internal subcircuit nodes are
* ordered in an IN/OUT format.  1 is the board end of the first chosen pin, 
* 2 is its die end. 3 is the board end of the 2nd chosen pin.  Etc.
*
.SUBCKT pk14 1 3 5 7 9 11 13 15 17 19
+  21 23 25 27
+  2 4 6 8 10 12 14 16 18 20
+  22 24 26 28
* pin resistors SI units, bondwire diameter, resistivity =  2.54E-05,  2.44E-08
* leadframe thickness, resistivity =  1.50E-04,  2.87E-08
R1 1 1001   3.46E-02
R2 3 1003   4.33E-02
R3 5 1005   2.80E-02
R4 7 1007   2.88E-02
R5 9 1009   2.80E-02
R6 11 1011   4.33E-02
R7 13 1013   3.46E-02
R8 15 1015   3.46E-02
R9 17 1017   4.33E-02
R10 19 1019   2.80E-02
R11 21 1021   2.88E-02
R12 23 1023   2.80E-02
R13 25 1025   4.33E-02
R14 27 1027   3.46E-02

* linear inductors leadframe thickness, resistivity =  1.50E-04,  2.87E-08
L1 1001 2   2.32E-09
L2 1003 4   2.04E-09
L3 1005 6   1.36E-09
L4 1007 8   1.38E-09
L5 1009 10   1.36E-09
L6 1011 12   2.04E-09
L7 1013 14   2.32E-09
L8 1015 16   2.32E-09
L9 1017 18   2.04E-09
L10 1019 20   1.36E-09
L11 1021 22   1.38E-09
L12 1023 24   1.36E-09
L13 1025 26   2.04E-09
L14 1027 28   2.31E-09
* mutual inductors small ones pruned
* If all the pins are in series, equivalent L =   2.56E-08  equivalent R =   4.81E-01
* If all the pins are in parallel, equivalent L =   1.24E-10  equivalent R =   2.38E-03
.ENDS pk14


* TITLE TSSOP16
* SPICE format. The pins chosen are shown by the inductor and resistor names.
* L7 or R7 shows that pin 7 was chosen.  Internal subcircuit nodes are
* ordered in an IN/OUT format.  1 is the board end of the first chosen pin, 
* 2 is its die end. 3 is the board end of the 2nd chosen pin.  Etc.
*
.SUBCKT pk16 1 3 5 7 9 11 13 15 17 19
+  21 23 25 27 29 31
+  2 4 6 8 10 12 14 16 18 20
+  22 24 26 28 30 32
* pin resistors SI units, bondwire diameter, resistivity =  2.54E-05,  2.44E-08
* leadframe thickness, resistivity =  1.50E-04,  2.87E-08
R1 1 1001   3.52E-02
R2 3 1003   3.70E-02
R3 5 1005   4.56E-02
R4 7 1007   4.00E-02
R5 9 1009   4.00E-02
R6 11 1011   4.56E-02
R7 13 1013   3.70E-02
R8 15 1015   3.52E-02
R9 17 1017   3.52E-02
R10 19 1019   3.70E-02
R11 21 1021   4.56E-02
R12 23 1023   4.00E-02
R13 25 1025   4.00E-02
R14 27 1027   4.56E-02
R15 29 1029   3.70E-02
R16 31 1031   3.52E-02

* linear inductors leadframe thickness, resistivity =  1.50E-04,  2.87E-08
L1 1001 2   2.40E-09
L2 1003 4   1.93E-09
L3 1005 6   1.76E-09
L4 1007 8   1.65E-09
L5 1009 10   1.65E-09
L6 1011 12   1.76E-09
L7 1013 14   1.93E-09
L8 1015 16   2.40E-09
L9 1017 18   2.40E-09
L10 1019 20   1.93E-09
L11 1021 22   1.76E-09
L12 1023 24   1.65E-09
L13 1025 26   1.65E-09
L14 1027 28   1.76E-09
L15 1029 30   1.93E-09
L16 1031 32   2.40E-09
* mutual inductors small ones pruned
.ENDS pk16


* TITLE ~ TSSOP20dGdV split Gnd and Vcc, die 1.25X1.83 mm
* SPICE format. The pins chosen are shown by the inductor and resistor names.
* L7 or R7 shows that pin 7 was chosen.  Internal subcircuit nodes are
* ordered in an IN/OUT format.  1 is the board end of the first chosen pin, 
* 2 is its die end. 3 is the board end of the 2nd chosen pin.  Etc.
*
.SUBCKT pk21 1 3 5 7 9 11 13 15 17 19
+  21 23 25 27 29 31 33 35 37 39
+  41
+  2 4 6 8 10 12 14 16 18 20
+  22 24 26 28 30 32 34 36 38 40
+  42
* pin resistors SI units, bondwire diameter, resistivity =  2.54E-05,  2.44E-08
* leadframe thickness, resistivity =  3.50E-05,  2.87E-08
R1 1 1001   6.63E-02
R2 3 1003   6.67E-02
R3 5 1005   8.34E-02
R4 7 1007   7.44E-02
R5 9 1009   7.10E-02
R6 11 1011   7.10E-02
R7 13 1013   7.44E-02
R8 15 1015   8.34E-02
R9 17 1017   6.67E-02
R10 19 1019   6.63E-02
R11 21 1021   6.63E-02
R12 23 1023   6.67E-02
R13 25 1025   8.34E-02
R14 27 1027   7.44E-02
R15 29 1029   7.10E-02
R16 31 1031   7.10E-02
R17 33 1033   7.44E-02
R18 35 1035   8.34E-02
R19 37 1037   6.67E-02
R20 39 1039   6.63E-02
R21 41 1041   6.27E-02

* linear inductors leadframe thickness, resistivity =  3.50E-05,  2.87E-08
L1 1001 2   3.18E-09
L2 1003 4   2.55E-09
L3 1005 6   2.35E-09
L4 1007 8   2.16E-09
L5 1009 10   2.09E-09
L6 1011 12   2.09E-09
L7 1013 14   2.16E-09
L8 1015 16   2.35E-09
L9 1017 18   2.55E-09
L10 1019 20   3.18E-09
L11 1021 22   3.17E-09
L12 1023 24   2.55E-09
L13 1025 26   2.35E-09
L14 1027 28   2.16E-09
L15 1029 30   2.09E-09
L16 1031 32   2.09E-09
L17 1033 34   2.16E-09
L18 1035 36   2.35E-09
L19 1037 38   2.55E-09
L20 1039 40   3.17E-09
L21 1041 42   3.44E-09
* mutual inductors small ones pruned
.ENDS pk21


* TITLE ~ TSSOP24: 24 pin thin shrink small outline package.
* SPICE format. The pins chosen are shown by the inductor and resistor names.
* L7 or R7 shows that pin 7 was chosen.  Internal subcircuit nodes are
* ordered in an IN/OUT format.  1 is the board end of the first chosen pin, 
* 2 is its die end. 3 is the board end of the 2nd chosen pin.  Etc.
*
.SUBCKT pk24 1 3 5 7 9 11 13 15 17 19
+  21 23 25 27 29 31 33 35 37 39
+  41 43 45 47
+  2 4 6 8 10 12 14 16 18 20
+  22 24 26 28 30 32 34 36 38 40
+  42 44 46 48
* pin resistors SI units, bondwire diameter, resistivity =  2.54E-05,  2.44E-08
* leadframe thickness, resistivity =  1.50E-04,  2.87E-08
R1 1 1001   6.61E-02
R2 3 1003   6.70E-02
R3 5 1005   6.64E-02
R4 7 1007   4.71E-02
R5 9 1009   3.80E-02
R6 11 1011   3.15E-02
R7 13 1013   3.15E-02
R8 15 1015   3.80E-02
R9 17 1017   4.71E-02
R10 19 1019   6.64E-02
R11 21 1021   6.70E-02
R12 23 1023   6.61E-02
R13 25 1025   6.62E-02
R14 27 1027   6.70E-02
R15 29 1029   6.65E-02
R16 31 1031   4.71E-02
R17 33 1033   3.80E-02
R18 35 1035   3.15E-02
R19 37 1037   3.15E-02
R20 39 1039   3.80E-02
R21 41 1041   4.71E-02
R22 43 1043   6.65E-02
R23 45 1045   6.70E-02
R24 47 1047   6.62E-02

* linear inductors leadframe thickness, resistivity =  1.50E-04,  2.87E-08
L1 1001 2   3.39E-09
L2 1003 4   2.94E-09
L3 1005 6   2.36E-09
L4 1007 8   1.67E-09
L5 1009 10   1.44E-09
L6 1011 12   1.32E-09
L7 1013 14   1.32E-09
L8 1015 16   1.44E-09
L9 1017 18   1.67E-09
L10 1019 20   2.36E-09
L11 1021 22   2.94E-09
L12 1023 24   3.39E-09
L13 1025 26   3.39E-09
L14 1027 28   2.94E-09
L15 1029 30   2.36E-09
L16 1031 32   1.67E-09
L17 1033 34   1.45E-09
L18 1035 36   1.32E-09
L19 1037 38   1.32E-09
L20 1039 40   1.45E-09
L21 1041 42   1.67E-09
L22 1043 44   2.36E-09
L23 1045 46   2.94E-09
L24 1047 48   3.39E-09
* mutual inductors small ones pruned
*K1 L2 L1   3.99E-01
*K2 L3 L2   3.70E-01
*K3 L4 L3   3.27E-01
*K4 L5 L4   3.17E-01
*K5 L6 L5   3.00E-01
*K6 L11 L10   3.70E-01
*K7 L12 L11   3.99E-01
*K8 L14 L13   4.02E-01
*K9 L15 L14   3.70E-01
*K10 L16 L15   3.29E-01
*K11 L17 L16   3.16E-01
*K12 L18 L17   2.99E-01
*K13 L23 L22   3.70E-01
*K14 L24 L23   4.02E-01
.ENDS pk24
*

* TITLE @ TSSOP48
* SPICE format. The pins chosen are shown by the inductor and resistor names.
* L7 or R7 shows that pin 7 was chosen.  Internal subcircuit nodes are
* ordered in an IN/OUT format.  1 is the board end of the first chosen pin, 
* 2 is its die end. 3 is the board end of the 2nd chosen pin.  Etc.
*
.SUBCKT pk48 1 3 5 7 9 11 13 15 17 19
+  21 23 25 27 29 31 33 35 37 39
+  41 43 45 47 49 51 53 55 57 59
+  61 63 65 67 69 71 73 75 77 79
+  81 83 85 87 89 91 93 95
+  2 4 6 8 10 12 14 16 18 20
+  22 24 26 28 30 32 34 36 38 40
+  42 44 46 48 50 52 54 56 58 60
+  62 64 66 68 70 72 74 76 78 80
+  82 84 86 88 90 92 94 96
* pin resistors SI units, bondwire diameter, resistivity =  2.54E-05,  2.44E-08
* leadframe thickness, resistivity =  1.50E-04,  2.87E-08
R1 1 1001   9.19E-02
R2 3 1003   9.16E-02
R3 5 1005   9.15E-02
R4 7 1007   9.01E-02
R5 9 1009   7.46E-02
R6 11 1011   5.79E-02
R7 13 1013   5.27E-02
R8 15 1015   4.91E-02
R9 17 1017   4.70E-02
R10 19 1019   4.68E-02
R11 21 1021   4.80E-02
R12 23 1023   4.76E-02
R13 25 1025   4.76E-02
R14 27 1027   4.80E-02
R15 29 1029   4.68E-02
R16 31 1031   4.70E-02
R17 33 1033   4.91E-02
R18 35 1035   5.27E-02
R19 37 1037   5.79E-02
R20 39 1039   7.46E-02
R21 41 1041   9.01E-02
R22 43 1043   9.15E-02
R23 45 1045   9.16E-02
R24 47 1047   9.19E-02
R25 49 1049   9.19E-02
R26 51 1051   9.17E-02
R27 53 1053   9.15E-02
R28 55 1055   9.01E-02
R29 57 1057   7.46E-02
R30 59 1059   5.79E-02
R31 61 1061   5.27E-02
R32 63 1063   4.91E-02
R33 65 1065   4.70E-02
R34 67 1067   4.68E-02
R35 69 1069   4.80E-02
R36 71 1071   4.76E-02
R37 73 1073   4.76E-02
R38 75 1075   4.80E-02
R39 77 1077   4.68E-02
R40 79 1079   4.70E-02
R41 81 1081   4.91E-02
R42 83 1083   5.27E-02
R43 85 1085   5.79E-02
R44 87 1087   7.46E-02
R45 89 1089   9.01E-02
R46 91 1091   9.15E-02
R47 93 1093   9.17E-02
R48 95 1095   9.19E-02

* linear inductors leadframe thickness, resistivity =  1.50E-04,  2.87E-08
L1 1001 2   7.29E-09
L2 1003 4   6.60E-09
L3 1005 6   6.00E-09
L4 1007 8   5.38E-09
L5 1009 10   4.77E-09
L6 1011 12   4.16E-09
L7 1013 14   3.96E-09
L8 1015 16   3.77E-09
L9 1017 18   3.57E-09
L10 1019 20   3.44E-09
L11 1021 22   3.36E-09
L12 1023 24   3.33E-09
L13 1025 26   3.33E-09
L14 1027 28   3.36E-09
L15 1029 30   3.44E-09
L16 1031 32   3.57E-09
L17 1033 34   3.77E-09
L18 1035 36   3.96E-09
L19 1037 38   4.16E-09
L20 1039 40   4.77E-09
L21 1041 42   5.38E-09
L22 1043 44   6.00E-09
L23 1045 46   6.60E-09
L24 1047 48   7.29E-09
L25 1049 50   7.29E-09
L26 1051 52   6.60E-09
L27 1053 54   6.00E-09
L28 1055 56   5.38E-09
L29 1057 58   4.77E-09
L30 1059 60   4.16E-09
L31 1061 62   3.96E-09
L32 1063 64   3.77E-09
L33 1065 66   3.57E-09
L34 1067 68   3.44E-09
L35 1069 70   3.36E-09
L36 1071 72   3.33E-09
L37 1073 74   3.33E-09
L38 1075 76   3.36E-09
L39 1077 78   3.44E-09
L40 1079 80   3.57E-09
L41 1081 82   3.77E-09
L42 1083 84   3.96E-09
L43 1085 86   4.16E-09
L44 1087 88   4.77E-09
L45 1089 90   5.38E-09
L46 1091 92   6.00E-09
L47 1093 94   6.60E-09
L48 1095 96   7.29E-09
* mutual inductors small ones pruned
K1 L2 L1   5.03E-01
K2 L3 L1   3.52E-01
K3 L3 L2   4.97E-01
K4 L4 L1   2.70E-01
K5 L4 L2   3.44E-01
K6 L4 L3   4.88E-01
K7 L5 L1   2.09E-01
K8 L5 L2   2.51E-01
K9 L5 L3   3.16E-01
K10 L5 L4   4.36E-01
K11 L6 L1   1.75E-01
K12 L6 L2   2.06E-01
K13 L6 L3   2.50E-01
K14 L6 L4   3.19E-01
K15 L6 L5   5.12E-01
K16 L7 L1   1.50E-01
K17 L7 L2   1.75E-01
K18 L7 L3   2.07E-01
K19 L7 L4   2.51E-01
K20 L7 L5   3.52E-01
K21 L7 L6   4.90E-01
K22 L8 L3   1.70E-01
K23 L8 L4   1.99E-01
K24 L8 L5   2.62E-01
K25 L8 L6   3.23E-01
K26 L8 L7   4.66E-01
K27 L9 L5   2.00E-01
K28 L9 L6   2.36E-01
K29 L9 L7   3.09E-01
K30 L9 L8   4.61E-01
K31 L10 L6   1.83E-01
K32 L10 L7   2.29E-01
K33 L10 L8   3.08E-01
K34 L10 L9   4.62E-01
K35 L11 L8   2.29E-01
K36 L11 L9   3.09E-01
K37 L11 L10   4.59E-01
K38 L12 L9   2.30E-01
K39 L12 L10   3.10E-01
K40 L12 L11   4.66E-01
K41 L13 L10   2.33E-01
K42 L13 L11   3.14E-01
K43 L13 L12   4.62E-01
K44 L14 L11   2.34E-01
K45 L14 L12   3.14E-01
K46 L14 L13   4.66E-01
K47 L15 L12   2.33E-01
K48 L15 L13   3.10E-01
K49 L15 L14   4.59E-01
K50 L16 L13   2.30E-01
K51 L16 L14   3.09E-01
K52 L16 L15   4.62E-01
K53 L17 L14   2.29E-01
K54 L17 L15   3.08E-01
K55 L17 L16   4.63E-01
K56 L18 L15   2.29E-01
K57 L18 L16   3.09E-01
K58 L18 L17   4.66E-01
K59 L19 L16   2.36E-01
K60 L19 L17   3.23E-01
K61 L19 L18   4.90E-01
K62 L20 L17   2.62E-01
K63 L20 L18   3.52E-01
K64 L20 L19   5.12E-01
K65 L21 L18   2.51E-01
K66 L21 L19   3.19E-01
K67 L21 L20   4.36E-01
K68 L22 L19   2.50E-01
K69 L22 L20   3.16E-01
K70 L22 L21   4.88E-01
K71 L23 L20   2.51E-01
K72 L23 L21   3.44E-01
K73 L23 L22   4.97E-01
K74 L24 L21   2.70E-01
K75 L24 L22   3.52E-01
K76 L24 L23   5.03E-01
K77 L26 L25   5.03E-01
K78 L27 L25   3.52E-01
K79 L27 L26   4.97E-01
K80 L28 L25   2.70E-01
K81 L28 L26   3.44E-01
K82 L28 L27   4.88E-01
K83 L29 L25   2.09E-01
K84 L29 L26   2.51E-01
K85 L29 L27   3.16E-01
K86 L29 L28   4.36E-01
K87 L30 L25   1.75E-01
K88 L30 L26   2.06E-01
K89 L30 L27   2.50E-01
K90 L30 L28   3.19E-01
K91 L30 L29   5.12E-01
K92 L31 L25   1.50E-01
K93 L31 L26   1.75E-01
K94 L31 L27   2.07E-01
K95 L31 L28   2.51E-01
K96 L31 L29   3.52E-01
K97 L31 L30   4.90E-01
K98 L32 L27   1.70E-01
K99 L32 L28   1.99E-01
K100 L32 L29   2.62E-01
K101 L32 L30   3.23E-01
K102 L32 L31   4.66E-01
K103 L33 L29   2.00E-01
K104 L33 L30   2.36E-01
K105 L33 L31   3.09E-01
K106 L33 L32   4.63E-01
K107 L34 L30   1.83E-01
K108 L34 L31   2.29E-01
K109 L34 L32   3.08E-01
K110 L34 L33   4.62E-01
K111 L35 L32   2.29E-01
K112 L35 L33   3.09E-01
K113 L35 L34   4.59E-01
K114 L36 L33   2.30E-01
K115 L36 L34   3.10E-01
K116 L36 L35   4.63E-01
K117 L37 L34   2.33E-01
K118 L37 L35   3.14E-01
K119 L37 L36   4.62E-01
K120 L38 L35   2.34E-01
K121 L38 L36   3.14E-01
K122 L38 L37   4.63E-01
K123 L39 L36   2.33E-01
K124 L39 L37   3.10E-01
K125 L39 L38   4.59E-01
K126 L40 L37   2.30E-01
K127 L40 L38   3.09E-01
K128 L40 L39   4.62E-01
K129 L41 L38   2.29E-01
K130 L41 L39   3.08E-01
K131 L41 L40   4.63E-01
K132 L42 L39   2.29E-01
K133 L42 L40   3.09E-01
K134 L42 L41   4.66E-01
K135 L43 L40   2.36E-01
K136 L43 L41   3.23E-01
K137 L43 L42   4.90E-01
K138 L44 L41   2.62E-01
K139 L44 L42   3.52E-01
K140 L44 L43   5.12E-01
K141 L45 L42   2.51E-01
K142 L45 L43   3.19E-01
K143 L45 L44   4.36E-01
K144 L46 L43   2.50E-01
K145 L46 L44   3.16E-01
K146 L46 L45   4.88E-01
K147 L47 L44   2.51E-01
K148 L47 L45   3.44E-01
K149 L47 L46   4.97E-01
K150 L48 L45   2.70E-01
K151 L48 L46   3.52E-01
K152 L48 L47   5.03E-01
.ENDS pk48
*
* TITLE @ TSSOP56
*SPICE format. The pins chosen are shown by the inductor and resistor names.
* L7 or R7 shows that pin 7 was chosen.  Internal subcircuit nodes are
* ordered in an IN/OUT format.  1 is the board end of the first chosen pin, 
* 2 is its die end. 3 is the board end of the 2nd chosen pin.  Etc.
*
.SUBCKT pk56 1 3 5 7 9 11 13 15 17 19
+  21 23 25 27 29 31 33 35 37 39
+  41 43 45 47 49 51 53 55 57 59
+  61 63 65 67 69 71 73 75 77 79
+  81 83 85 87 89 91 93 95 97 99
+  101 103 105 107 109 111
+  2 4 6 8 10 12 14 16 18 20
+  22 24 26 28 30 32 34 36 38 40
+  42 44 46 48 50 52 54 56 58 60
+  62 64 66 68 70 72 74 76 78 80
+  82 84 86 88 90 92 94 96 98 100
+  102 104 106 108 110 112
* pin resistors SI units, bondwire diameter, resistivity =  2.54E-05,  2.44E-08
* leadframe thickness, resistivity =  1.50E-04,  2.87E-08
R1 1 1001   8.33E-02
R2 3 1003   8.43E-02
R3 5 1005   8.56E-02
R4 7 1007   8.67E-02
R5 9 1009   8.92E-02
R6 11 1011   9.14E-02
R7 13 1013   8.73E-02
R8 15 1015   9.18E-02
R9 17 1017   8.08E-02
R10 19 1019   7.23E-02
R11 21 1021   6.59E-02
R12 23 1023   6.28E-02
R13 25 1025   6.03E-02
R14 27 1027   5.85E-02
R15 29 1029   5.85E-02
R16 31 1031   6.03E-02
R17 33 1033   6.28E-02
R18 35 1035   6.59E-02
R19 37 1037   7.23E-02
R20 39 1039   8.08E-02
R21 41 1041   9.18E-02
R22 43 1043   8.73E-02
R23 45 1045   9.14E-02
R24 47 1047   8.92E-02
R25 49 1049   8.67E-02
R26 51 1051   8.56E-02
R27 53 1053   8.43E-02
R28 55 1055   8.33E-02
R29 57 1057   8.33E-02
R30 59 1059   8.43E-02
R31 61 1061   8.56E-02
R32 63 1063   8.67E-02
R33 65 1065   8.92E-02
R34 67 1067   9.14E-02
R35 69 1069   8.73E-02
R36 71 1071   9.18E-02
R37 73 1073   8.08E-02
R38 75 1075   7.23E-02
R39 77 1077   6.59E-02
R40 79 1079   6.28E-02
R41 81 1081   6.03E-02
R42 83 1083   5.85E-02
R43 85 1085   5.85E-02
R44 87 1087   6.03E-02
R45 89 1089   6.28E-02
R46 91 1091   6.59E-02
R47 93 1093   7.23E-02
R48 95 1095   8.08E-02
R49 97 1097   9.18E-02
R50 99 1099   8.73E-02
R51 101 1101   9.14E-02
R52 103 1103   8.92E-02
R53 105 1105   8.67E-02
R54 107 1107   8.56E-02
R55 109 1109   8.43E-02
R56 111 1111   8.33E-02

* linear inductors leadframe thickness, resistivity =  1.50E-04,  2.87E-08
L1 1001 2   7.61E-09
L2 1003 4   7.08E-09
L3 1005 6   6.49E-09
L4 1007 8   5.96E-09
L5 1009 10   5.38E-09
L6 1011 12   4.93E-09
L7 1013 14   4.50E-09
L8 1015 16   4.27E-09
L9 1017 18   3.91E-09
L10 1019 20   3.69E-09
L11 1021 22   3.46E-09
L12 1023 24   3.30E-09
L13 1025 26   3.15E-09
L14 1027 28   3.09E-09
L15 1029 30   3.09E-09
L16 1031 32   3.15E-09
L17 1033 34   3.30E-09
L18 1035 36   3.46E-09
L19 1037 38   3.69E-09
L20 1039 40   3.91E-09
L21 1041 42   4.27E-09
L22 1043 44   4.50E-09
L23 1045 46   4.93E-09
L24 1047 48   5.38E-09
L25 1049 50   5.96E-09
L26 1051 52   6.49E-09
L27 1053 54   7.08E-09
L28 1055 56   7.61E-09
L29 1057 58   7.61E-09
L30 1059 60   7.08E-09
L31 1061 62   6.49E-09
L32 1063 64   5.96E-09
L33 1065 66   5.38E-09
L34 1067 68   4.93E-09
L35 1069 70   4.50E-09
L36 1071 72   4.27E-09
L37 1073 74   3.91E-09
L38 1075 76   3.69E-09
L39 1077 78   3.46E-09
L40 1079 80   3.30E-09
L41 1081 82   3.15E-09
L42 1083 84   3.09E-09
L43 1085 86   3.09E-09
L44 1087 88   3.15E-09
L45 1089 90   3.30E-09
L46 1091 92   3.46E-09
L47 1093 94   3.69E-09
L48 1095 96   3.91E-09
L49 1097 98   4.27E-09
L50 1099 100   4.50E-09
L51 1101 102   4.93E-09
L52 1103 104   5.38E-09
L53 1105 106   5.96E-09
L54 1107 108   6.49E-09
L55 1109 110   7.08E-09
L56 1111 112   7.61E-09
* mutual inductors small ones pruned
K1 L2 L1   5.67E-01
K2 L3 L1   4.13E-01
K3 L3 L2   5.46E-01
K4 L4 L1   3.31E-01
K5 L4 L2   4.03E-01
K6 L4 L3   5.50E-01
K7 L5 L1   2.66E-01
K8 L5 L2   3.11E-01
K9 L5 L3   3.84E-01
K10 L5 L4   5.07E-01
K11 L6 L1   2.25E-01
K12 L6 L2   2.59E-01
K13 L6 L3   3.08E-01
K14 L6 L4   3.76E-01
K15 L6 L5   5.38E-01
K16 L7 L1   1.95E-01
K17 L7 L2   2.21E-01
K18 L7 L3   2.57E-01
K19 L7 L4   3.03E-01
K20 L7 L5   3.90E-01
K21 L7 L6   5.27E-01
K22 L8 L1   1.69E-01
K23 L8 L2   1.89E-01
K24 L8 L3   2.18E-01
K25 L8 L4   2.52E-01
K26 L8 L5   3.09E-01
K27 L8 L6   3.77E-01
K28 L8 L7   5.16E-01
K29 L9 L1   1.45E-01
K30 L9 L2   1.63E-01
K31 L9 L3   1.84E-01
K32 L9 L4   2.09E-01
K33 L9 L5   2.49E-01
K34 L9 L6   2.92E-01
K35 L9 L7   3.60E-01
K36 L9 L8   4.92E-01
K37 L10 L3   1.54E-01
K38 L10 L4   1.71E-01
K39 L10 L5   2.00E-01
K40 L10 L6   2.27E-01
K41 L10 L7   2.67E-01
K42 L10 L8   3.33E-01
K43 L10 L9   4.66E-01
K44 L11 L5   1.62E-01
K45 L11 L6   1.81E-01
K46 L11 L7   2.09E-01
K47 L11 L8   2.50E-01
K48 L11 L9   3.21E-01
K49 L11 L10   4.67E-01
K50 L12 L8   1.96E-01
K51 L12 L9   2.42E-01
K52 L12 L10   3.21E-01
K53 L12 L11   4.71E-01
K54 L13 L9   1.88E-01
K55 L13 L10   2.39E-01
K56 L13 L11   3.15E-01
K57 L13 L12   4.59E-01
K58 L14 L10   1.90E-01
K59 L14 L11   2.41E-01
K60 L14 L12   3.16E-01
K61 L14 L13   4.65E-01
K62 L15 L11   1.92E-01
K63 L15 L12   2.42E-01
K64 L15 L13   3.24E-01
K65 L15 L14   4.69E-01
K66 L16 L13   2.43E-01
K67 L16 L14   3.24E-01
K68 L16 L15   4.65E-01
K69 L17 L14   2.42E-01
K70 L17 L15   3.16E-01
K71 L17 L16   4.59E-01
K72 L18 L15   2.41E-01
K73 L18 L16   3.15E-01
K74 L18 L17   4.71E-01
K75 L19 L16   2.39E-01
K76 L19 L17   3.21E-01
K77 L19 L18   4.67E-01
K78 L20 L17   2.42E-01
K79 L20 L18   3.21E-01
K80 L20 L19   4.66E-01
K81 L21 L18   2.50E-01
K82 L21 L19   3.33E-01
K83 L21 L20   4.92E-01
K84 L22 L19   2.67E-01
K85 L22 L20   3.60E-01
K86 L22 L21   5.16E-01
K87 L23 L20   2.92E-01
K88 L23 L21   3.77E-01
K89 L23 L22   5.27E-01
K90 L24 L20   2.49E-01
K91 L24 L21   3.09E-01
K92 L24 L22   3.90E-01
K93 L24 L23   5.38E-01
K94 L25 L21   2.52E-01
K95 L25 L22   3.03E-01
K96 L25 L23   3.76E-01
K97 L25 L24   5.07E-01
K98 L26 L22   2.57E-01
K99 L26 L23   3.08E-01
K100 L26 L24   3.84E-01
K101 L26 L25   5.50E-01
K102 L27 L23   2.59E-01
K103 L27 L24   3.11E-01
K104 L27 L25   4.03E-01
K105 L27 L26   5.46E-01
K106 L28 L24   2.66E-01
K107 L28 L25   3.31E-01
K108 L28 L26   4.13E-01
K109 L28 L27   5.67E-01
K110 L29 L28   2.04E-01
K111 L30 L29   5.67E-01
K112 L31 L29   4.13E-01
K113 L31 L30   5.46E-01
K114 L32 L29   3.31E-01
K115 L32 L30   4.03E-01
K116 L32 L31   5.50E-01
K117 L33 L29   2.66E-01
K118 L33 L30   3.11E-01
K119 L33 L31   3.84E-01
K120 L33 L32   5.07E-01
K121 L34 L29   2.25E-01
K122 L34 L30   2.59E-01
K123 L34 L31   3.08E-01
K124 L34 L32   3.76E-01
K125 L34 L33   5.38E-01
K126 L35 L29   1.95E-01
K127 L35 L30   2.21E-01
K128 L35 L31   2.57E-01
K129 L35 L32   3.03E-01
K130 L35 L33   3.90E-01
K131 L35 L34   5.27E-01
K132 L36 L29   1.69E-01
K133 L36 L30   1.89E-01
K134 L36 L31   2.18E-01
K135 L36 L32   2.52E-01
K136 L36 L33   3.09E-01
K137 L36 L34   3.77E-01
K138 L36 L35   5.16E-01
K139 L37 L29   1.45E-01
K140 L37 L30   1.63E-01
K141 L37 L31   1.84E-01
K142 L37 L32   2.09E-01
K143 L37 L33   2.49E-01
K144 L37 L34   2.92E-01
K145 L37 L35   3.60E-01
K146 L37 L36   4.92E-01
K147 L38 L31   1.54E-01
K148 L38 L32   1.71E-01
K149 L38 L33   2.00E-01
K150 L38 L34   2.27E-01
K151 L38 L35   2.67E-01
K152 L38 L36   3.33E-01
K153 L38 L37   4.66E-01
K154 L39 L33   1.62E-01
K155 L39 L34   1.81E-01
K156 L39 L35   2.09E-01
K157 L39 L36   2.50E-01
K158 L39 L37   3.21E-01
K159 L39 L38   4.67E-01
K160 L40 L36   1.96E-01
K161 L40 L37   2.42E-01
K162 L40 L38   3.21E-01
K163 L40 L39   4.71E-01
K164 L41 L37   1.88E-01
K165 L41 L38   2.40E-01
K166 L41 L39   3.18E-01
K167 L41 L40   4.59E-01
K168 L42 L38   1.90E-01
K169 L42 L39   2.41E-01
K170 L42 L40   3.16E-01
K171 L42 L41   4.62E-01
K172 L43 L39   1.92E-01
K173 L43 L40   2.42E-01
K174 L43 L41   3.24E-01
K175 L43 L42   4.69E-01
K176 L44 L41   2.43E-01
K177 L44 L42   3.21E-01
K178 L44 L43   4.62E-01
K179 L45 L42   2.42E-01
K180 L45 L43   3.16E-01
K181 L45 L44   4.59E-01
K182 L46 L43   2.41E-01
K183 L46 L44   3.18E-01
K184 L46 L45   4.71E-01
K185 L47 L44   2.40E-01
K186 L47 L45   3.21E-01
K187 L47 L46   4.67E-01
K188 L48 L45   2.42E-01
K189 L48 L46   3.21E-01
K190 L48 L47   4.66E-01
K191 L49 L46   2.50E-01
K192 L49 L47   3.33E-01
K193 L49 L48   4.92E-01
K194 L50 L47   2.67E-01
K195 L50 L48   3.60E-01
K196 L50 L49   5.16E-01
K197 L51 L48   2.92E-01
K198 L51 L49   3.77E-01
K199 L51 L50   5.27E-01
K200 L52 L48   2.49E-01
K201 L52 L49   3.09E-01
K202 L52 L50   3.90E-01
K203 L52 L51   5.38E-01
K204 L53 L49   2.52E-01
K205 L53 L50   3.03E-01
K206 L53 L51   3.76E-01
K207 L53 L52   5.07E-01
K208 L54 L50   2.57E-01
K209 L54 L51   3.08E-01
K210 L54 L52   3.84E-01
K211 L54 L53   5.50E-01
K212 L55 L51   2.59E-01
K213 L55 L52   3.11E-01
K214 L55 L53   4.03E-01
K215 L55 L54   5.46E-01
K216 L56 L1   2.04E-01
K217 L56 L52   2.66E-01
K218 L56 L53   3.31E-01
K219 L56 L54   4.13E-01
K220 L56 L55   5.67E-01
.ENDS pk56
